<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Detective;

/**
 * Detective controller.
 *
 * @Route("/detective")
 */
class DetectiveController extends Controller
{
    /**
     * Lists all Detective entities.
     *
     * @Route("/index.html", name="detective")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Detective')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Detective entity.
     *
     * @Route("/{slug}.html", name="detective_show")
     * @Template()
     */
    public function showAction($slug)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Detective')->findOneBySlug($slug);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Detective entity.');
        }

        return array('entity' => $entity);
    }

}
