<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Kontynent;

class KontynentController extends Controller
{
    /**
     * Lista kontynentow
     *
     * @Route("/kontynenty.html", name="kontynent_index")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();
        $entities = $em->getRepository('MyFrontendBundle:Kontynent')->findAll();
        return array('entities' => $entities);
    }

    /**
     * Szczegolowe dane kontynentu
     *
     * @Route("/kontynent/{id}.html", name="kontynent_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();
        $entity = $em->getRepository('MyFrontendBundle:Kontynent')->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Brak kontynentu o podanym id!');
        }
        return array('entity' => $entity);
    }
}