<?php

namespace My\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\BackendBundle\Entity\Mountain;
use My\BackendBundle\Form\MountainType;

/**
 * Mountain controller.
 */
class MountainController extends Controller
{
    /**
     * Lists all Mountain entities.
     *
     * @Route("/", name="mountain")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyBackendBundle:Mountain')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Mountain entity.
     *
     * @Route("/{id}/show", name="mountain_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyBackendBundle:Mountain')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Mountain entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),        );
    }

    /**
     * Displays a form to create a new Mountain entity.
     *
     * @Route("/new", name="mountain_new")
     * @Template()
     */
    public function newAction()
    {
        $entity = new Mountain();
        $form   = $this->createForm(new MountainType(), $entity);

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Creates a new Mountain entity.
     *
     * @Route("/create", name="mountain_create")
     * @Method("post")
     * @Template("MyBackendBundle:Mountain:new.html.twig")
     */
    public function createAction()
    {
        $entity  = new Mountain();
        $request = $this->getRequest();
        $form    = $this->createForm(new MountainType(), $entity);
        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('mountain_show', array('id' => $entity->getId())));
            
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Displays a form to edit an existing Mountain entity.
     *
     * @Route("/{id}/edit", name="mountain_edit")
     * @Template()
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyBackendBundle:Mountain')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Mountain entity.');
        }

        $editForm = $this->createForm(new MountainType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Edits an existing Mountain entity.
     *
     * @Route("/{id}/update", name="mountain_update")
     * @Method("post")
     * @Template("MyBackendBundle:Mountain:edit.html.twig")
     */
    public function updateAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyBackendBundle:Mountain')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Mountain entity.');
        }

        $editForm   = $this->createForm(new MountainType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        $request = $this->getRequest();

        $editForm->bindRequest($request);

        if ($editForm->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('mountain_edit', array('id' => $id)));
        }

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Deletes a Mountain entity.
     *
     * @Route("/{id}/delete", name="mountain_delete")
     * @Method("post")
     */
    public function deleteAction($id)
    {
        $form = $this->createDeleteForm($id);
        $request = $this->getRequest();

        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $entity = $em->getRepository('MyBackendBundle:Mountain')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Mountain entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('mountain'));
    }

    private function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
        ;
    }
}
