<?php

/*
 * Copyright 2011 Johannes M. Schmitt <schmittjoh@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace JMS\DiExtraBundle\Annotation;

use JMS\DiExtraBundle\Exception\InvalidArgumentException;
use JMS\DiExtraBundle\Exception\InvalidTypeException;

/**
 * @Annotation
 * @Target("CLASS")
 */
final class Tag
{
    /** @var string @Required */
    public $name;

    /** @var array */
    public $attributes = array();

    public function __construct()
    {
        if (0 === func_num_args()) {
            return;
        }
        $values = func_get_arg(0);

        if (!isset($values['value'])) {
            throw new InvalidArgumentException('A value must be given for annotation "@Tag".');
        }
        if (!is_string($values['value'])) {
            throw new InvalidTypeException('Tag', 'value', 'string', $values['value']);
        }

        $this->name = $values['value'];

        if (isset($values['attributes'])) {
            if (!is_array($values['attributes'])) {
                throw new InvalidTypeException('Tag', 'attributes', 'array', $values['attributes']);
            }

            $this->attributes = $values['attributes'];
        }
    }
}