<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Aktor;
use My\FrontendBundle\Form\AktorType;

/**
 * Aktor controller.
 *
 * @Route("/aktor")
 */
class AktorController extends Controller
{
    /**
     * Lists all Aktor entities.
     *
     * @Route("/", name="aktor")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Aktor')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Aktor entity.
     *
     * @Route("/{id}/show", name="aktor_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Aktor')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Aktor entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),        );
    }

    /**
     * Displays a form to create a new Aktor entity.
     *
     * @Route("/new", name="aktor_new")
     * @Template()
     */
    public function newAction()
    {
        $entity = new Aktor();
        $form   = $this->createForm(new AktorType(), $entity);

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Creates a new Aktor entity.
     *
     * @Route("/create", name="aktor_create")
     * @Method("post")
     * @Template("MyFrontendBundle:Aktor:new.html.twig")
     */
    public function createAction()
    {
        $entity  = new Aktor();
        $request = $this->getRequest();
        $form    = $this->createForm(new AktorType(), $entity);
        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('aktor_show', array('id' => $entity->getId())));
            
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Displays a form to edit an existing Aktor entity.
     *
     * @Route("/{id}/edit", name="aktor_edit")
     * @Template()
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Aktor')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Aktor entity.');
        }

        $editForm = $this->createForm(new AktorType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Edits an existing Aktor entity.
     *
     * @Route("/{id}/update", name="aktor_update")
     * @Method("post")
     * @Template("MyFrontendBundle:Aktor:edit.html.twig")
     */
    public function updateAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Aktor')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Aktor entity.');
        }

        $editForm   = $this->createForm(new AktorType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        $request = $this->getRequest();

        $editForm->bindRequest($request);

        if ($editForm->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('aktor_edit', array('id' => $id)));
        }

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Deletes a Aktor entity.
     *
     * @Route("/{id}/delete", name="aktor_delete")
     * @Method("post")
     */
    public function deleteAction($id)
    {
        $form = $this->createDeleteForm($id);
        $request = $this->getRequest();

        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $entity = $em->getRepository('MyFrontendBundle:Aktor')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Aktor entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('aktor'));
    }

    private function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
        ;
    }
}
