<?php

namespace My\FrontendBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use My\FrontendBundle\Entity\Color;
use Symfony\Component\Yaml\Yaml;


class LoadData implements FixtureInterface
{

    public function load($manager)
    {
        $yml = Yaml::parse('data/kolory.yml');
        foreach ($yml as $c) {
            $Color = new Color();
            $Color->setRgb($c['rgb']);
            $Color->setName($c['name']);
            $manager->persist($Color);
            $manager->flush();

            foreach ($c['translations'] as $lang => $translation) {
                $Color->setTranslatableLocale($lang);
                $Color->setName($translation);
                $manager->persist($Color);
                $manager->flush();
            }
        }
    }

}
