<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

//Uwaga: konflikt nazw z klasą Sensio\Bundle\FrameworkExtraBundle\Configuration\Method
//
//use My\FrontendBundle\Entity\Method;

/**
 * Method controller.
 *
 * @Route("/method")
 */
class MethodController extends Controller
{
    /**
     * Lists all Method entities.
     *
     * @Route("/index.html", name="method")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Method')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Method entity.
     *
     * @Route("/{slug}.html", name="method_show")
     * @Template()
     */
    public function showAction($slug)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Method')->findOneBySlug($slug);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Method entity.');
        }

        return array('entity' => $entity);
    }

}
