<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Panstwo;

class PanstwoController extends Controller
{
    /**
     * Lista wszystkich panstw
     *
     * @Route("/panstwa/html", name="panstwo_index")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();
        $entities = $em->getRepository('MyFrontendBundle:Panstwo')->findAll();
        return array('entities' => $entities);
    }

    /**
     * Szczegolowe dane panstwa
     *
     * @Route("/panstwo/{id}.html", name="panstwo_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();
        $entity = $em->getRepository('MyFrontendBundle:Panstwo')->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Brak panstwa o podanym id!');
        }
        return array('entity' => $entity);
    }


}
