<?php

namespace My\FrontendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use My\FrontendBundle\Entity\Name;
use My\FrontendBundle\Form\NameType;

/**
 * Name controller.
 *
 */
class NameController extends Controller
{
    /**
     * Lists all Name entities.
     *
     * @Route("/", name="name")
     * @Template()
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entities = $em->getRepository('MyFrontendBundle:Name')->findAll();

        return array('entities' => $entities);
    }

    /**
     * Finds and displays a Name entity.
     *
     * @Route("/{id}/show", name="name_show")
     * @Template()
     */
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Name')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Name entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),        );
    }

    /**
     * Displays a form to create a new Name entity.
     *
     * @Route("/new", name="name_new")
     * @Template()
     */
    public function newAction()
    {
        $entity = new Name();
        $form   = $this->createForm(new NameType(), $entity);

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Creates a new Name entity.
     *
     * @Route("/create", name="name_create")
     * @Method("post")
     * @Template("MyFrontendBundle:Name:new.html.twig")
     */
    public function createAction()
    {
        $entity  = new Name();
        $request = $this->getRequest();
        $form    = $this->createForm(new NameType(), $entity);
        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('name_show', array('id' => $entity->getId())));
            
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView()
        );
    }

    /**
     * Displays a form to edit an existing Name entity.
     *
     * @Route("/{id}/edit", name="name_edit")
     * @Template()
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Name')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Name entity.');
        }

        $editForm = $this->createForm(new NameType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Edits an existing Name entity.
     *
     * @Route("/{id}/update", name="name_update")
     * @Method("post")
     * @Template("MyFrontendBundle:Name:edit.html.twig")
     */
    public function updateAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();

        $entity = $em->getRepository('MyFrontendBundle:Name')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Name entity.');
        }

        $editForm   = $this->createForm(new NameType(), $entity);
        $deleteForm = $this->createDeleteForm($id);

        $request = $this->getRequest();

        $editForm->bindRequest($request);

        if ($editForm->isValid()) {
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('name_edit', array('id' => $id)));
        }

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        );
    }

    /**
     * Deletes a Name entity.
     *
     * @Route("/{id}/delete", name="name_delete")
     * @Method("post")
     */
    public function deleteAction($id)
    {
        $form = $this->createDeleteForm($id);
        $request = $this->getRequest();

        $form->bindRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getEntityManager();
            $entity = $em->getRepository('MyFrontendBundle:Name')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Name entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('name'));
    }

    private function createDeleteForm($id)
    {
        return $this->createFormBuilder(array('id' => $id))
            ->add('id', 'hidden')
            ->getForm()
        ;
    }
}
