<?php

namespace My\FrontendBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * My\FrontendBundle\Entity\Tren
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="My\FrontendBundle\Entity\TrenRepository")
 */
class Tren
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $tytul
     *
     * @ORM\Column(name="tytul", type="string", length=64)
     */
    private $tytul;

    /**
     * @var text $tresc
     *
     * @ORM\Column(name="tresc", type="text")
     */
    private $tresc;

    /**
     * @var integer $numer
     *
     * @ORM\Column(name="numer", type="integer")
     */
    private $numer;

    /**
     * @Gedmo\Slug(fields={"tytul"})
     * @ORM\Column(length=64, unique=true)
     */
    private $slug;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set tytul
     *
     * @param string $tytul
     */
    public function setTytul($tytul)
    {
        $this->tytul = $tytul;
    }

    /**
     * Get tytul
     *
     * @return string 
     */
    public function getTytul()
    {
        return $this->tytul;
    }

    /**
     * Set tresc
     *
     * @param text $tresc
     */
    public function setTresc($tresc)
    {
        $this->tresc = $tresc;
    }

    /**
     * Get tresc
     *
     * @return text 
     */
    public function getTresc()
    {
        return $this->tresc;
    }

    /**
     * Set numer
     *
     * @param integer $numer
     */
    public function setNumer($numer)
    {
        $this->numer = $numer;
    }

    /**
     * Get numer
     *
     * @return integer 
     */
    public function getNumer()
    {
        return $this->numer;
    }

    /**
     * Sets properties using array
     *
     * @param array $data
     */
    public function fromArray(array $data)
    {
        foreach ($data as $key => $value) {
            $methodName = 'set' . ucfirst($key);
            $this->$methodName($value);
        }
    }

    /**
     * Get title
     *
     * @return string
     */
    public function __toString()
    {
        return $this->getTytul();
    }


    /**
     * Set slug
     *
     * @param string $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * Get slug
     *
     * @return string 
     */
    public function getSlug()
    {
        return $this->slug;
    }
}