#include <iostream>
#include <vector>
#include <complex>
#include <tuple>
using namespace std;

struct Creature
{
    int attack, health;

    Creature(int attack, int health) : attack(attack), health(health) {}
};

struct CardGame
{
    vector<Creature> creatures;

    CardGame(const vector<Creature> &creatures) : creatures(creatures) {}

    // zwr -1, jeli nie ma wyranego zwycizcy
    int combat(int creature1, int creature2)
    {
      Creature& first = creatures[creature1];
      Creature& second = creatures[creature2];
      hit(first, second);
      hit(second, first);
      bool first_alive = first.health > 0;
      bool second_alive = second.health > 0;
      if (first_alive == second_alive) return -1;
      return first_alive ? creature1 : creature2;
    }

    virtual void hit(Creature& attacker, Creature& other) = 0;
};

struct TemporaryCardCombatGame : CardGame
{
    TemporaryCardCombatGame(const vector<Creature> &creatures) : CardGame(creatures) {}

    void hit(Creature &attacker, Creature &other) override {
      auto old_health = other.health;
      other.health -= attacker.attack;
      if (other.health > 0) other.health = old_health;
    }
};

struct PermanentCardCombatGame : CardGame
{
    PermanentCardCombatGame(const vector<Creature> &creatures) : CardGame(creatures) {}

    void hit(Creature &attacker, Creature &other) override
    {
      other.health -= attacker.attack;
    }
};

#include "gtest/gtest.h"

//#include "helpers/iohelper.h"

//#include "exercise.cpp"

namespace {

    class Evaluate : public ::testing::Test {};

    TEST_F(Evaluate, ImpasseTest)
    {
      Creature c1{1,2};
      Creature c2{1,2};
      TemporaryCardCombatGame game({c1,c2});
      ASSERT_EQ(-1, game.combat(0,1));
      ASSERT_EQ(-1, game.combat(0,1));
    }

    TEST_F(Evaluate, TemporaryDefeatTest)
    {
      Creature c1{1,1};
      Creature c2{2,2};
      TemporaryCardCombatGame game({c1,c2});
      ASSERT_EQ(1, game.combat(0,1));
    }

    TEST_F(Evaluate, DoubleDefeatTest)
    {
      Creature c1{2,2};
      Creature c2{2,2};
      TemporaryCardCombatGame game({c1,c2});
      ASSERT_EQ(-1, game.combat(0,1)) << "Oczekuje si, e dwie postacie 2/2 zakocz zmagania remisem";
    }

    TEST_F(Evaluate, PermanentCombatDefeatTest)
    {
      Creature c1{1,2};
      Creature c2{1,3};
      PermanentCardCombatGame game({c1, c2});
      ASSERT_EQ(-1, game.combat(0,1)) << "W zmaganiach postaci 1/2 i 1/3 po pierwszej rundzie nie powinno by zwycizcy";
      ASSERT_EQ(1, game.combat(0,1)) << "Tu walcz postaci 1/1 i 1/2, wic zwyciy powinna posta = 1";
    }

}  // namespace

int main(int ac, char* av[])
{
  //::testing::GTEST_FLAG(catch_exceptions) = false;
  testing::InitGoogleTest(&ac, av);
  return RUN_ALL_TESTS();
}