#include <iostream>
#include <string>
#include <vector>
#include <numeric>
#include <sstream>
using namespace std;

struct Flower
{
  virtual string str() = 0;
};

struct Rose : Flower
{
  string str() override {
    return "Ra";
  }
};

struct RedFlower : Flower
{
  Flower& flower;

  RedFlower(Flower &flower) : flower(flower) {}

  string str() override
  {
    string s = flower.str();
    if (s.find("czerwona") != string::npos) return s;
    else if (s.find("niebieska") != string::npos)
    {
      return s + " i czerwona";
    }
    else return s + ", ktra jest czerwona";
  }
};

struct BlueFlower : Flower
{
  Flower& flower;

  BlueFlower(Flower &flower) : flower(flower) {}

  string str() override
  {
    string s = flower.str();
    if (s.find("niebieska") != string::npos) return s;
    else if (s.find("czerwona") != string::npos)
    {
      return s + " i niebieska";
    }
    else return s + ", ktra jest niebieska";
  }
};

#include "gtest/gtest.h"

//#include "helpers/iohelper.h"

//#include "exercise.cpp"

namespace
{
  class Evaluate : public testing::Test
  {
  public:
    Rose rose;
    BlueFlower blue_rose{rose};
    RedFlower red_rose{rose};
  };

  TEST_F(Evaluate, BaselineTest)
  {
    ASSERT_EQ("Ra", Rose{}.str());
  }

  TEST_F(Evaluate, SingleColorTests)
  {
    ASSERT_EQ("Ra, ktra jest niebieska", blue_rose.str());
    ASSERT_EQ("Ra, ktra jest czerwona", red_rose.str());
  }

  TEST_F(Evaluate, RepetitionTest)
  {
    ASSERT_EQ("Ra, ktra jest czerwona", RedFlower{red_rose}.str())
            << "Ta ra bya uczyniona czerwon dwa razy, ale naley wypisa to tyko raz.";
  }

  TEST_F(Evaluate, MultiColorTests)
  {
    ASSERT_EQ("Ra, ktra jest czerwona i niebieska",
      BlueFlower{red_rose}.str());
    ASSERT_EQ("Ra, ktra jest niebieska i czerwona",
      RedFlower{blue_rose}.str());
  }

  TEST_F(Evaluate, NestedRepetitionTest)
  {
    BlueFlower b_r_rose{red_rose};
    RedFlower r_b_r_rose{b_r_rose};
    ASSERT_EQ("Ra, ktra jest czerwona i niebieska",
      r_b_r_rose.str())
      << "To skomplikowany przypadek. Spodziewam si, "
      << "ra zdefiniowana jako Red{Blue{Red{Rose{}}}} bdzie wywietlana "
      << "jako 'czerwona i niebieska'.";
  }

} // namespace

int main(int ac, char* av[])
{
  testing::InitGoogleTest(&ac, av);
  return RUN_ALL_TESTS();
}