
// AdapterVisualDlg.cpp : plik implementacji
//

#include "stdafx.h"
#include "AdapterVisual.h"
#include "AdapterVisualDlg.h"
#include "afxdialogex.h"

#include <memory>
#include <map>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

vector<shared_ptr<VectorObject>> vectorObjects{
  make_shared<VectorRectangle>(10,10,100,100),
  make_shared<VectorRectangle>(30,30,60,60)
};

struct LineToPointAdapter
{
  typedef vector<Point> Points;

  LineToPointAdapter(Line& line)
  {
    static int count = 0;
    TRACE("%d: Generowanie punktw linii (bez buforowania)\n", count++);

    // bez interpolacji
    int left = min(line.start.x, line.end.x);
    int right = max(line.start.x, line.end.x);
    int top = min(line.start.y, line.end.y);
    int bottom = max(line.start.y, line.end.y);
    int dx = right - left;
    int dy = line.end.y - line.start.y;
    
    // tylko linie pionowe lub poziome
    if (dx == 0)
    {
      // pionowa
      for (int y = top; y <= bottom; ++y)
      {
        points.emplace_back(Point{ left,y });
      }
    } 
    else if (dy == 0)
    {
      for (int x = left; x <= right; ++x)
      {
        points.emplace_back(Point{ x, top });
      }
    }
  }

  virtual Points::iterator begin() { return points.begin(); }
  virtual Points::iterator end() { return points.end(); }
private:
  Points points;
};

struct LineToPointCachingAdapter
{
  typedef vector<Point> Points;

  LineToPointCachingAdapter(Line& line)
  {
    boost::hash<Line> hash;
    line_hash = hash(line);
    if (cache.find(line_hash) != cache.end())
      return; // linia ju jest w buforze

    static int count = 0;
    TRACE("%d: Generowanie punktw linii (z buforowaniem)\n", count++);

    // bez interpolacji
    Points points;

    int left = min(line.start.x, line.end.x);
    int right = max(line.start.x, line.end.x);
    int top = min(line.start.y, line.end.y);
    int bottom = max(line.start.y, line.end.y);
    int dx = right - left;
    int dy = line.end.y - line.start.y;
    
    // tylko linie pionowe lub poziome
    if (dx == 0)
    {
      // pionowa
      for (int y = top; y <= bottom; ++y)
      {
        points.emplace_back(Point{ left,y });
      }
    } 
    else if (dy == 0)
    {
      for (int x = left; x <= right; ++x)
      {
        points.emplace_back(Point{ x, top });
      }
    }

    cache[line_hash] = points;
  }

  virtual Points::iterator begin() { return cache[line_hash].begin(); }
  virtual Points::iterator end() { return cache[line_hash].end(); }
private:
  size_t line_hash;
  static map<size_t, Points> cache;
};

map<size_t, vector<Point>> LineToPointCachingAdapter::cache;

// Okno dialogowe CAboutDlg uywane na potrzeby informacji o aplikacji

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dane okna dialogowego
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // obsuga DDX/DDV

// Implementacja
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// Okno dialogowe CAdapterVisualDlg



CAdapterVisualDlg::CAdapterVisualDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_ADAPTERVISUAL_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAdapterVisualDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAdapterVisualDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// Procedury obsugi komunikatw CAdapterVisualDlg

BOOL CAdapterVisualDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Dodaj pozycj "Informacje..." do menu systemowego.

	// Element IDM_ABOUTBOX musi nalee do zakresu polece systemowych.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Ustaw ikon dla tego okna dialogowego. Struktura wykonuje to automatycznie
	//  dy okno gwne aplikacji nie jest oknem dialogowym
	SetIcon(m_hIcon, TRUE);			// Ustaw due ikony
	SetIcon(m_hIcon, FALSE);		// Ustaw mae ikony

	// TODO: Dodaj tutaj dodatkowe inicjowanie

	return TRUE;  // zwracaj warto TRUE, dopki fokus nie zostanie ustawiony na formant
}

void CAdapterVisualDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// Jeli dodasz przycisk minimalizacji do okna dialogowego, bdziesz potrzebowa poniszego kodu
//  aby narysowa ikon. Dla aplikacji MFC uywajcych modelu dokumentu/widoku
//  to jest wykonywane automatycznie przez struktur.

void CAdapterVisualDlg::OnPaint()
{
  CPaintDC dc(this); // kontekst urzdzenia dotyczcy malowania

	if (IsIconic())
	{
		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Wyrodkuj ikon w prostokcie klienta
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Rysuj ikon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
    for (auto& o : vectorObjects)
    {
      for (auto& l : *o)
      {
        LineToPointCachingAdapter lpo{ l };
        DrawPoints(dc, lpo.begin(), lpo.end());
      }
    }
    
    CDialogEx::OnPaint();
	}

}

// System wywouje t funkcj, aby uzyska kursor wywietlany podczas przecigania przez uytkownika
//  zminimalizowane okno.
HCURSOR CAdapterVisualDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

