#include <iostream>
#include <string>
#include <vector>
#include <tuple>
using namespace std;

// A. Wysokopoziomowe moduy nie powinny zalee od moduw niskiego poziomu.
//    I jedne, i drugie powinny zalee od abstrakcji.
// B. Abstrakcje nie powinny zalee od szczegw.
//    To szczegy powinny zalee od abstrakcji.

enum class Relationship
{
  parent,
  child,
  sibling
};

struct Person
{
  string name;
};

struct RelationshipBrowser
{
  virtual vector<Person> find_all_children_of(const string& name) = 0;
};

struct Relationships : RelationshipBrowser // niski poziom
{
  vector<tuple<Person, Relationship, Person>> relations;

  void add_parent_and_child(const Person& parent, const Person& child)
  {
    relations.push_back({parent, Relationship::parent, child});
    relations.push_back({child, Relationship::child, parent});
  }

  vector<Person> find_all_children_of(const string &name) override
  {
    vector<Person> result;
    for (auto&& [first, rel, second] : relations)
    {
      if (first.name == name && rel == Relationship::parent)
      {
        result.push_back(second);
      }
    }
    return result;
  }
};

struct Research // wysoki poziom
{
  Research(RelationshipBrowser& browser)
  {
    for (auto& child : browser.find_all_children_of("Jan"))
    {
      cout << "Jan ma dziecko o imieniu " << child.name << endl;
    }
  }
//  Research(const Relationships& relationships)
//  {
//    auto& relations = relationships.relations;
//    for (auto&& [first, rel, second] : relations)
//    {
//      if (first.name == "Jan" && rel == Relationship::parent)
//      {
//        cout << "Jan ma dziecko o imieniu " << second.name << endl;
//      }
//    }
//  }
};

int main()
{
  Person parent{"Jan"};
  Person child1{"Krzysztof"};
  Person child2{"Mateusz"};

  Relationships relationships;
  relationships.add_parent_and_child(parent, child1);
  relationships.add_parent_and_child(parent, child2);

  Research _(relationships);

  return 0;
}