using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using TMPro;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using CustomExtensions;
using System.Linq;

public class GameBehavior : MonoBehaviour, IManager
{
    public int maxItems = 4;

    public TMP_Text HealthText;
    public TMP_Text ItemText;
    public TMP_Text ProgressText;

    public Button WinButton;
    public Button LossButton;

    public Stack<Loot> LootStack = new Stack<Loot>();

    private string _state;
    public string State
    {
        get { return _state; }
        set { _state = value; }
    }

    void Start()
    {
        ItemText.text += _itemsCollected;
        HealthText.text += _playerHP;
        Initialize();
    }

    public void Initialize()
    {
        _state = "Menedżer zainicjowany...";
        _state.FancyDebug();
        Debug.Log(_state);

        LootStack.Push(new Loot("Miecz losu ", 5));
        LootStack.Push(new Loot("Dodatkowe życie", 1));
        LootStack.Push(new Loot("Złoty klucz", 3));
        LootStack.Push(new Loot("Skrzydlate buty ", 2));
        LootStack.Push(new Loot("Magiczne szelki", 4));

        FilterLoot();
    }

    private int _itemsCollected = 0;
    public int Items
    {
        get { return _itemsCollected; }
        set
        {
            _itemsCollected = value;
            ItemText.text = "Przedmioty: " + Items;

            if (_itemsCollected >= MaxItems)
            {
                WinButton.gameObject.SetActive(true);
                UpdateScene("Znalazłeś wszystkie przedmioty!");
            }
            else
            {
                ProgressText.text = "Przedmiot znaleziony. Jeszcze " + (MaxItems - _ itemsCollected) +" do końca!";
            }
        }
    }

    private int _playerHP = 10;
    public int HP
    {

        get { return _playerHP; }
        set
        {
            _playerHP = value;
            HealthText.text = "Kondycja: " + HP;

            if (_playerHP <= 0)
            {
                LossButton.gameObject.SetActive(true);
                UpdateScene("Czy potrzebujesz kolejnego życia?");
            }
            else
            {
                ProgressText.text = "Ojej ... To boli.";
            }

            Debug.LogFormat("Kondycja: {0}", _playerHP);
        }
    }

    public void RestartScene()
    {
        Utilities.RestartLevel(0);
    }

    public void UpdateScene(string updatedText)
    {
        ProgressText.text = updatedText;
        Time.timeScale = 0f;
    }

    public void PrintLootReport()
    {
        var currentItem = LootStack.Pop();
        var nextItem = LootStack.Peek();

        Debug.LogFormat("Zebrałeś {0}! Teraz masz szansę na znalezienie {1}!", currentItem.name, nextItem.name);
        Debug.LogFormat("Na stosie oczekuje na Ciebie {0} losowych przedmiotów!", LootStack.Count);
    }

    public void FilterLoot()
    {
        //var rareLoot = LootStack
        //    .Where(item => item.rarity >= 3)
        //    .OrderBy(item => item.rarity)
        //    .Select(item => new
        //    {
        //        item.name
        //    });

        var rareLoot = (from item in LootStack
                       where item.rarity >= 3
                       orderby item.rarity
                       select new { item.name })
                       .Skip(1);

        foreach (var item in rareLoot)
        {
            Debug.LogFormat("Rzadki okaz: {0}!", item.name);
        }
    }

    //public bool LootPredicate(Loot loot)
    //{
    //    return loot.rarity >= 3;
    //}
}
