
# Stwórz_Grę_w Unity_i_Naucz_Się_Programować 
To jest repozytorium kodu dla polskiego wydania książki [Learning-C-by-Developing-Games-with-Unity-Seventh-Edition](https://www.amazon.com/Learning-Developing-Games-Unity-coding/dp/1837636877), wydanej przez Packt.

**Zapoznaj się z kodowaniem w języku C# i stwórz od podstaw proste gry 3D w Unity 2022 **

## O książce 
Możliwość pisania niestandardowych skryptów w C# w celu implementacji zachowania i obsługi mechaniki do gry czynią z Unity unikatowe środowisko. Właśnie w tym zakresie ta książka może pomóc początkującym programistom! 

Harrison Ferrone w siódmym wydaniu bestsellerowej serii przeprowadzi Cię przez podstawy programowania i języka C#, a jednocześnie zbuduje wraz z tobą zabawny i grywalny prototyp gry w Unity.

Ta książka nauczy Cię podstaw programowania obiektowego, podstawowych pojęć związanych z językiem C# i silnikiem Unity. Książka zawiera wiele przykładów kodu, ćwiczeń i wskazówek, dzięki którym Twoja praca wyjdzie poza ramy materiału opisanego w książce.

Nauczysz się pisać skrypty C# w celu obsługi mechaniki prostych gier, programować proceduralnie oraz zwiększać złożoność swoich gier poprzez wprowadzenie inteligentnych wrogów i pocisków zadających obrażenia.  W każdym rozdziale poznasz tajniki tworzenia gier Unity, w tym projektowania gier, podstaw oświetlenia, ruchów gracza, sterowania kamerą, kolizji itp. 

## Czego się nauczysz?

- Podstawy programowania opisane w kontekście podstawowych komponentów języka C#.
- Kompleksowy opis programowania obiektowego oraz jego zastosowania w języku C#.
- Proste procedury krok po kroku i przykłady tworzenia i stposowania skryptów C# w środowisku Unity.
- Dzielenie kodu na moduły, które można dołączać do programów z wykorzystaniem interfejsów, klas abstrakcyjnych i rozszerzeń. 
- Podstawy dokumentacji projektowej gry, tworzenia bloków geometrii poziomu, dodawania oświetlenia oraz prostej animacji obiektów. 
- Implementacja za pomocą języka C# podstawowej mechaniki gry oraz sterowania graczem i strzelania pociskami. 
- Opis stosów, kolejek, wyjątków, obsługi błędów i innych podstawowych pojęć języka C#. 
- Obsługa danych tekstowych, XML i JSON w celu zapisywania danych gry i ich ładowania.


## Spis treści 
### Rozdziały
1. Poznaj środowisko
2. Bloki budulcowe programowania
3. Zmienne, typy i metody
4. Przepływ sterowania i kolekcje
5. Klasy, struktury i programowanie obiektowe
6. Ubrudź sobie ręce silnikiem Unity
7. Ruch, sterowanie kamerą i kolizje
8. Skrypty do obsługi mechaniki gry
9. Podstawy sztucznej inteligencji. Zachowania nieprzyjaciół
10. Więcej o typach, metodach i klasach
11. Wyspecjalizowane typy kolekcji i LINQ
12. Zapisywanie, ładowanie i serializowanie danych
13. Typy generyczne, delegaty i nie tylko
14. Dalsza podróż


> Jeśli czujesz, że ta książka jest dla Ciebie, sięgnij po [egzemplarz](https://www.amazon.com/Learning-Developing-Games-Unity-coding/dp/1837636877) już dziś! <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">


### Oto, czego potrzebujesz, aby zacząć lekturę tej książki: ###

Jedynymi rzeczami, których potrzebujesz, aby wyciągnąć jak najwięcej z lektury książki o C# i Unity jest ciekawość i chęć nauki. Wykonanie ćwiczeń z kodem, samodzielne uruchamianie gry Narodziny bohatera i udzielanie odpowiedzi na pytania zamieszczone w punktach „Quiz” jest niezbędne do scementowania poznanej wiedzy.  
Wreszcie, zawsze dobrym pomysłem jest powracanie do tematów i całych rozdziałów, aby odświeżyć lub utrwalić zawarte w nich informacje. Budowanie domu na niestabilnych fundamentach nie ma sensu.

Potrzebne będzie również zainstalowanie na komputerze aktualnej wersji Unity. Zalecana jest wersja 2022 lub nowsza. Wszystkie przykłady kodu zostały przetestowane w Unity 2022.1 i powinny bezproblemowo działać także z wersjami przyszłymi.

Korzystając z poniższej listy oprogramowania i sprzętu, możesz uruchomić wszystkie pliki kodu zawarte w książce.

## Lista oprogramowania i sprzętu 

| Wymagane oprogramowanie/sprzęt | 
| :---:  | 
| Unity 2022.1 lub wersja nowsza | 
| Visual Studio 2019 lub wersja nowsza | 
| C# 8.0 lub wersja nowsza | 

Zanim zaczniesz lekturę tej książki sprawdź, czy konfiguracja Twojego komputera spełnia wymagania systemowe Unity. Możesz je znaleźć [pod adresem] (https://docs.unity3d.com/2022.1/Documentation/Manual/system-requirements.html).

## Dowiedz się więcej w serwisie Discord  <img alt="Coding" height="25" width="32"  src="https://cliply.co/wp-content/uploads/2021/08/372108630_DISCORD_LOGO_400.gif">

Aby zaangażować się w dyskusję oraz uzyskać dostęp do najnowszych aktualizacji i dyskusji w społeczności,odwiedź stronę [https://packt.link/csharpwithunity](https://packt.link/csharpwithunity) 

## Pobierz darmowy plik PDF <img alt="Coding" height="25" width="40" src="https://emergency.com.au/wp-content/uploads/2021/03/free.gif">

_Jeśli już kupiłeś wersję drukowaną lub wersję Kindle tej książki, możesz bezpłatnie otrzymać wersję PDF bez ograniczeń. Po prostu kliknij łącze, aby odebrać bezpłatny plik PDF._ 
[https://packt.link/free-ebook/9781837636877](https://packt.link/free-ebook/9781837636877) <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">

Udostępniamy również plik PDF zawierający kolorowe wersje zrzutów ekranów i rysunków użytych w tej książce "https://packt.link/7yy5V" <img alt="Coding" height="15" width="35"  src="https://media.tenor.com/ex_HDD_k5P8AAAAi/habbo-habbohotel.gif">.


## Poznaj autora

**Harrison Ferrone** urodził się i dorastał w Chicago, w Stanie Illinois. Pracował w firmie Microsoft, PricewaterhouseCoopers i kilku małych startupach, ale większość czasu poświęca tworzeniu dokumentacji technicznych dla firm LinkedIn Learning i Pluralsight oraz redagowaniu artykułów technicznych w witrynie Ray Wenderlich.

Posiada różne dyplomy i certyfikaty z Uniwersytetu Stanu Colorado w Boulder i Columbia College w Chicago. Chociaż jest dumnym absolwentem tych uczelni, większa część z tych papierków leży gdzieś w piwnicy.

Po kilku latach pracy na stanowisku programisty iOS i Unity w małych startupach rozpoczął pracę dydaktyczną i nigdy nie spojrzał wstecz. W trakcie swojej kariery kupił wiele książek, nabył kilka kotów, pracował za granicą i nieustannie zastanawiał się, dlaczego powieści Neuromancer nie ma już wśród lektur.
