/*---------------------------------------------------------------------------*/
    #include <errno.h>
    #include <fcntl.h>
    #include <stdio.h>
    #include <sys/mman.h>
    #include <sys/stat.h>
    #include <sys/types.h>
    #include <unistd.h>

    int main( int argc, char **argv ) {
        int fd;
        unsigned char *image;
        struct stat s;
    
        if ( argc < 2 ) {
            fprintf(stderr, "Uycie: %s nazwa_pliku\n", argv[0]);
            return(1);    
        }
        if ( stat( argv[1], &s) ) {
            fprintf(stderr, "Bd: %s\n", strerror(errno) );
            return(2);
        }
        fd = open( argv[1], O_RDONLY );
        if ( fd < 0 )  {
            fprintf(stderr, "Bd: %s\n", strerror(errno) );
            return(3);
        }
        image = mmap(0, s.st_size, PROT_READ, MAP_SHARED, fd, 0);
        if ( (int) image < 0 ) {
            fprintf(stderr, "Bd: %s\n", strerror(errno) );
            return(4);
        }

        /* w tym miejscu dostp do pliku jest moliwy przez 'fd' lub 'image' */
        printf( "Pooenie punktu wejcia: 0x%X\n", 
                    elf_header_read( image, s.st_size ) );

        munmap( image, s.st_size );
        close(fd);
        return(0);
    }
/*--------------------------------------------------------------------*/
