#--------------------------------------------------------------------------
    #!/usr/bin/perl
    # insn_list.pl -- przykad tworzenia listy powizanej instrukcji 

    my $file = shift;
    my $insn, $prev_insn, $head;
    if (! $file ) {
            $file = "-";
    }
    open( A, $file ) || die "Nie mog otworzy $file\n";

    foreach (<A>) {
    if ( /^INSN/ ) {
        chomp;
        $insn = new_insn( $_ );

        if ( $prev_insn ) { 
            $$insn{prev} = $prev_insn;
            $$prev_insn{next} = $insn; 
        } else {
            $head = $insn;
        }
        $prev_insn = $insn;
    } else {
        print;
    }
}
close (A);


$insn = $head;
while ( $insn ) {
    # tu wstaw kod dziaajcy na licie
     print "insn $$insn{addr} : ";
     print "$$insn{mnem}\t$$insn{dest}\t$$insn{src}\n";
     $insn = $$insn{next};
}

# tworzenie nowej struktury instrukcji
sub new_insn {
    local($line) = @_;
    local(%i, $jnk);
    # naley to zmieni, gdy zmieni si format pliku wejciowego!
    ( $jnk, $i{addr}, $i{name}, $i{size}, $i{bytes},
      $i{mnem}, $i{mtype}, $i{src}, $i{stype},
      $i{dest}, $i{dtype}, $i{arg}, $i{atype} ) = 
        split '\|', $line;
    return \%i;
}
#--------------------------------------------------------------------------
