#------------------------------------------------------------------------------
    #!/usr/bin/perl
    # insn_output.pl -- wywietla zdeasemblowany kod
    #                   UWAGA: ignoruje wiersz SEC i DATA

    my $file = shift;
    my %insn, $i;
    my @xrefs, $xrefstr;
    if (! $file ) {
            $file = "-";
    }
    open( A, $file ) || die "Nie mog otworzy $file\n";

    foreach (<A>) {
        if ( /^INSN|/ ) {
            chomp;
            $i = new_insn( $_ );
            $insn{$$i{addr}} = $i;
        } else {
            ; # ignoruj inne wiersze
        }
    }
    close (A);


    foreach ( sort keys %insn ) {
        $i = $insn{$_};
        $xrefstr = "";
        @xrefs = undef;
        if ($$i{name}) {    
            print "\n$$i{name}:\n";    
        } elsif ( $$i{xrefs} ) {
            # generuje sfaszowan nazw
            print "\nloc_$$i{addr}:\n";
            @xrefs = split ':', $$i{xrefs};
            foreach ( @xrefs ) {
                $xrefstr .= " $_";
            }
        }
        print "\t$$i{mnem}\t";
        if ( $$i{src} ) {
            print_op( $$i{src}, $$i{stype} );
            if ( $$i{dest} ) {
                print ", ";
                print_op( $$i{dest}, $$i{dtype} );
                if ( $$i{arg} ) {
                    print ", ";
                    print_op( $$i{arg}, $$i{atype} );
                }
            }
        }
        print "\t\t(Addr: $$i{addr})";
        if ( $xrefstr ne "" ) {
            print " Odwoania:$xrefstr";
        }
        print "\n";
    }
    
    sub print_op {
        local($op, $op_type) = @_;
        local $addr, $i;
        if ( $op_type eq "OP_ADDR" && $op =~ /0[xX]([0-9a-fA-F]+)/ ) {
            # zamiana adresw nazwami
            $addr = $1;
            $i = $insn{$addr};
            if ( $$i{name} ) {
                print "$$i{name}";
            } else {
                print "loc_$addr";
            }
        } else {
            print "$op";
        }
        return;
    }
    
    # generuje struktur nowej instrukcji na podstawie wiersza
    sub new_insn {
        local($line) = @_;
        local(%i, $jnk);
        # naley to zmieni w przypadku zmiany formatu pliku wejciowego!
        ( $jnk, $i{addr}, $i{name}, $i{size}, $i{bytes},
          $i{mnem}, $i{mtype}, $i{src}, $i{stype},
          $i{dest}, $i{dtype}, $i{arg}, $i{atype}, $i{xrefs} ) = 
            split '\|', $line;
        return \%i;
    }
#--------------------------------------------------------------------------
