### Tworzymy instancję klasy Watcher w celu nałsuchiwania wpisów w dzienniku zdarzeń zabezpieczeń
$watcher = New-Object  System.Diagnostics.Eventing.Reader.EventLogWatcher("Security")
$watcher.Enabled = $true

### Procedura obsługi zdarzeń, która jest uruchamiana przy każdym wyzwoleniu nowego zdarzenia naruszenia bezpieczeństwa
$OnEventWritten =
{
   ### Ustawienia konfiguracyjne
   $logfile               = "$env:USERPROFILE\sentinel.log"
   $honeypot_searchfilter = "*passwords.txt*"
   $email                 = "<twój_adres_e-mail>"
   $smtp_server           = "smtp-mail.outlook.com"
   $subject               = "[Powiadomienie Strażnika] Uzyskano dostęp do pliku honeypota."

   $e = $event.sourceEventArgs.EventRecord

   ### Nasłuchujemy zdarzeń inspekcji, które żądają uchwytu do pliku honeypota
   if ($e.Id -eq 4656)
   {
     try
     {  
        ### Ładujemy zaszyfrowane poświadczenia e-mailowe z PasswordVault
        [void][Windows.Security.Credentials.PasswordVault, Windows.Security.Credentials, ContentType=WindowsRuntime]
        $vault      = New-Object Windows.Security.Credentials.PasswordVault
        $emailpwd   = ($vault.Retrieve("Sentinel",$email).Password) | ConvertTo-SecureString -AsPlainText -Force
        $emailcreds = New-Object System.Management.Automation.PsCredential($email, $emailpwd)

        if ($e.FormatDescription() -like $honeypot_searchfilter)
        {
           ### Zapisujemy wspis dziennika
           $e.FormatDescription() >> $logfile

           ### Wysyłamy również e-mail
           Send-MailMessage -From $email -To $email -Subject $subject -Body $e.FormatDescription() -Priority High -SmtpServer $smtp_server -Port 587 -UseSSL -Credential $emailcreds
        }
     }
     catch
     {
        $_ >> $logfile
     } 
  }
}

### Zarejestrowanie procedury obsługi zdarzeń
Register-ObjectEvent -InputObject $watcher -EventName EventRecordWritten -Action $OnEventWritten -SourceIdentifier SentinelNotify
