﻿// TELEFONICZNE BIURO OBSŁUGI KLIENTA Z JEDNYM KONSULTANTEM
// Rozdział 5. (Stosy i kolejki)
// Struktury danych i algorytmy w języku C#, wydanie drugie

Random random = new();

CallCenter center = new();
center.Call(1234);
center.Call(5678);
center.Call(1468);
center.Call(9641);

while (center.AreWaitingCalls())
{
    IncomingCall call = center.Answer("Marcin")!;
    Log($"Połączenie nr {call.Id} od klienta {call.ClientId} odebrał { call.Consultant}.");
    await Task.Delay(random.Next(1000, 10000));
    center.End(call);
    Log($"Połączenie nr {call.Id} z klientem {call.ClientId} zakończył { call.Consultant}."); 
}

void Log(string text) => Console.WriteLine($"[{DateTime.Now:HH:mm:ss}] {text}");
