﻿// CZYTNIK KSIĄŻKI
// Rozdział 4. (Warianty list)
// Struktury danych i algorytmy w języku C#, wydanie drugie

Page p1 = new("Witam w pierwszym rozdziale, w którym zaczniesz swoją niezwykłą przygodę ze strukturami danych i algorytmami w kontekście języka programowania C#. Na początku pokrótce go Ci przedstawię. Dowiesz się, jak szerokie ma on możliwości i w jak wielu sytuacjach można go wykorzystać. Pokażę również jego podstawowe konstrukcje. Nie jest to kurs C#, więc nie będę przedstawiał po kolei rozmaitych możliwości tego języka, lecz poprzestanę na krótkim opisie.");
Page p2 = new("Przeczytawszy pierwszy rozdział tej książki, masz wiedzę na temat różnych typów danych. Najwyższy więc czas przybliżyć Ci temat algorytmów. W tym rozdziale przyjrzysz się definicji, a także kilku praktycznym przykładom, zapisowi i typom algorytmów. Ponieważ należy dbać o wydajność aplikacji, poruszę i wyjaśnię również temat złożoności obliczeniowej, w tym czasowej, algorytmów.");
Page p3 = new("Jako programista z pewnością przechowywałeś w swoich aplikacjach różne kolekcje, takie jak dane użytkownika, książki albo logi. Jednym z naturalnych sposobów przechowywania takich danych jest użycie tablic. Czy jednak myślałeś kiedykolwiek o ich wariantach? Czy słyszałeś na przykład o tablicach nieregularnych albo o listach cyklicznych? W tym rozdziale zobaczysz działanie takich struktur danych wraz z przykładami i dokładnym opisem.");
Page p4 = new("W poprzednim rozdziale była mowa o tablicach i ich typach. Nie są one oczywiście jedynym sposobem przechowywania danych. Inna, popularna i mająca jeszcze większe możliwości grupa struktur danych obejmuje różne warianty list. W tym rozdziale zobaczysz działanie takich struktur danych wraz z przykładami i dokładnym opisem.");
Page p5 = new("Do tej pory dowiedziałeś się sporo na temat tablic i list, ale nie są one jedynymi dostępnymi strukturami danych. Istnieje również grupa bardziej wyspecjalizowanych struktur danych o dostępie sekwencyjnym (ang. limited access data structures).");
Page p6 = new("Niniejszy rozdział skupia się na strukturach danych pokrewnych ze słownikami i zbiorami. Dzięki zastosowaniu tych struktur danych można mapować klucze na wartości, przeprowadzać szybkie wyszukiwania, a także dokonywać rozmaitych działań na zbiorach. Aby ułatwić Ci zrozumienie słowników i zbiorów, rozdział ten zawiera ilustracje i listingi oraz szczegółowe opisy.");

LinkedList<Page> pages = new();
pages.AddLast(p2);
LinkedListNode<Page> n4 = pages.AddLast(p4);
pages.AddLast(p6);
pages.AddFirst(p1);
pages.AddBefore(n4, p3);
pages.AddAfter(n4, p5);

LinkedListNode<Page> c = pages.First!;
int number = 1;
while (c != null)
{
    Console.Clear();
    string page = $"- {number} -";
    int spaces = (90 - page.Length) / 2;
    Console.WriteLine(page.PadLeft(spaces + page.Length));
    Console.WriteLine();

    string content = c.Value.Content;
    for (int i = 0; i < content.Length; i += 90)
    {
        string line = content[i..];
        line = line.Length > 90 ? line[..90] : line;
        Console.WriteLine(line.Trim());
    }

    Console.WriteLine($"\nCytat z książki Marcina Jamry \"Struktury danych i algorytmy w języku C#\", Helion, 2025 r.\n");
    Console.Write(c.Previous != null ? "< POPRZEDNIA [P]" : GetSpaces(14));
    Console.Write(c.Next != null ? "[N] NASTĘPNA >".PadLeft(74) : string.Empty);
    Console.WriteLine();

    ConsoleKey key = Console.ReadKey(true).Key;
    if (key == ConsoleKey.N && c.Next != null)
    {
        c = c.Next;
        number++;
    }
    else if (key == ConsoleKey.P && c.Previous != null)
    {
        c = c.Previous;
        number--;
    }
}

string GetSpaces(int number) => string.Join(null, Enumerable.Range(0, number).Select(n => " "));
