﻿// CIĄG FIBONACCIEGO
// Rozdział 9. (Zobacz w działaniu)
// Struktury danych i algorytmy w języku C#, wydanie drugie

// Prosta implementacja rekurencyjna:
// long Fibonacci(int n)
// {
//     if (n == 0) { return 0; }
//     if (n == 1) { return 1; }
//     return Fibonacci(n - 1) + Fibonacci(n - 2);
// }

// Programowanie dynamiczne metodą zstępującą:
// Dictionary<int, long> cache = [];
// long Fibonacci(int n)
// {
//     if (n == 0) { return 0; }
//     if (n == 1) { return 1; }
//     if (cache.ContainsKey(n)) { return cache[n]; }
//     long result = Fibonacci(n - 1) + Fibonacci(n - 2);
//     cache[n] = result;
//     return result;
// }

// Programowanie dynamiczne metodą wstępującą:
long Fibonacci(int n)
{
    if (n == 0) { return 0; }
    if (n == 1) { return 1; }

    long a = 0;
    long b = 1;
    for (int i = 2; i <= n; i++)
    {
        long result = a + b;
        a = b;
        b = result;
    }

    return b;
}

long result = Fibonacci(25);
Console.WriteLine($"F(25) = {result}");
