﻿// AUTOMATYCZNE UZUPEŁNIANIE
// Rozdział 7 (Warianty drzew)
// Struktury danych i algorytmy w C#, wydanie II

using System.Text.RegularExpressions;

Trie trie = new();
string[] countries = await File.ReadAllLinesAsync("Countries.txt");
foreach (string country in countries)
{
    Regex regex = new("[^a-z]");
    string name = country.ToLower();
    name = regex.Replace(name, string.Empty);
    trie.Insert(name);
}

string text = string.Empty;
while (true)
{
    Console.Write("Wpisz następną literę: ");
    ConsoleKeyInfo key = Console.ReadKey();
    if (key.KeyChar < 'a' || key.KeyChar > 'z') { return; }
    text = (text + key.KeyChar).ToLower();
    List<string> results = trie.SearchByPrefix(text);
    if (results.Count == 0) { return; }
    Console.WriteLine($"\nPodpowiedzi do {text.ToUpper()}:");
    results.ForEach(r => Console.WriteLine(r.ToUpper()));
    Console.WriteLine();
}
