﻿using System;
using Microsoft.SqlServer.Server;
using System.Diagnostics;

public partial class Triggers
{
    [Microsoft.SqlServer.Server.SqlTrigger(
        Name = "ddlLogCreateTable", 
        Target = "DATABASE", 
        Event = "FOR CREATE_TABLE")]
    public static void LogCreateTable()
    {
        string source = "SQL Server 2008";
        SqlTriggerContext context = SqlContext.TriggerContext;

        if (!EventLog.SourceExists(source))
        {
            EventLog.CreateEventSource(source, "Katmai");
        }

        EventLog log = new EventLog();
        log.Source = source;
        log.WriteEntry(context.EventData.Value);
    }
}
