USE AdventureWorksDW2008

SELECT COUNT(*)
FROM dbo.FactResellerSales

SELECT SalesAmount
FROM dbo.FactResellerSales

SELECT SalesAmount, TaxAmt, OrderQuantity, Freight
FROM dbo.FactResellerSales

SELECT SUM(SalesAmount), SUM(TaxAmt), SUM(OrderQuantity), SUM(Freight)
FROM dbo.FactResellerSales

SELECT (TaxAmt/SalesAmount*100), TaxAmt, SalesAmount
FROM dbo.FactResellerSales;
SELECT SUM(TaxAmt/SalesAmount*100), SUM(TaxAmt)
FROM dbo.FactResellerSales

SELECT SUM(SalesAmount)
FROM dbo.FactResellerSales

SELECT EmployeeKey, SUM(SalesAmount)
FROM dbo.FactResellerSales 
GROUP BY EmployeeKey

SELECT CustomerKey, CustomerAlternateKey, FirstName, LastName, BirthDate, Gender, YearlyIncome, NumberCarsOwned
FROM dbo.DimCustomer

SELECT W.Gender, SUM(SalesAmount) 
FROM dbo.FactInternetSales AS F
JOIN dbo.DimCustomer AS W ON F.CustomerKey = W.CustomerKey 
GROUP BY W.Gender

SELECT DateKey, FullDateAlternateKey, WeekNumberOfYear, MonthNumberOfYear, CalendarYear, EnglishDayNameOfWeek, EnglishMonthName 
FROM dbo.DimDate

SELECT OrderDateKey, DueDateKey, ShipDateKey
FROM dbo.FactResellerSales

EXEC sp_configure 'show advanced options',1
RECONFIGURE
EXEC sp_configure 'fill factor (%)' 

CREATE INDEX IX_FactResellerSales_DueDateKey
ON dbo.FactResellerSales(DueDateKey)

CREATE INDEX IX_DimEmployee_EndDate
ON dbo.DimEmployee(EndDate)
WHERE EndDate IS NOT NULL

CREATE INDEX IX_FactResellerSales_SalesAmount
ON dbo.FactResellerSales(SalesAmount)

CREATE INDEX IX_DimProduct_EnglishProductName
ON dbo.DimProduct(EnglishProductName)

CREATE PARTITION FUNCTION udfFunkcjaPatycjonujaca (INT)
AS RANGE RIGHT FOR VALUES (20010101, 20020101);

CREATE PARTITION SCHEME SchematPartycjonowania
AS PARTITION udfFunkcjaPatycjonujaca
ALL TO ([PRIMARY]);

--Konsola SSMS

EXEC sp_estimate_data_compression_savings 'dbo','FactInternetSales',NULL,NULL,'ROW'

EXEC sp_estimate_data_compression_savings 'dbo','FactInternetSales',NULL,NULL,'PAGE'

