﻿using System;
using System.Windows.Forms;

namespace DataValidationDemo
{
    public partial class CaseLikelihood : Form
    {
        private readonly double _probability;
        private readonly int _percent;

        public CaseLikelihood(double probability, int percent)
        {
            InitializeComponent();

            _probability = probability;
            _percent = percent;
        }

        private void CaseLikelihood_Load(object sender, EventArgs e)
        {
            arcScaleComponent1.Value = (float)Math.Round((_probability * 100), 0);
            arcScaleComponent2.Value = _percent;
        }

        private void btnImproveData_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Yes;
            Close();
        }

        private void btnSubmit_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.No;
            Close();
        }
    }
}
