﻿using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using Helpers;

namespace DataValidationDemo
{
    public partial class DataValidation : Form
    {
        private string _sProbability = "";
        private double _dProbability;
        private int _min;

        public DataValidation()
        {
            InitializeComponent();
        }

        private void btnSubmit_Click(object sender, EventArgs e)
        {
            SetControlsDefaultBackground();

            var cp = DatabaseHelper.GetCustomerProbability(txtAge.Text, txtChildren.Text, cmbCommuteDistance.Items[cmbCommuteDistance.SelectedIndex].ToString(),
                cmbCountry.Items[cmbCountry.SelectedIndex].ToString(), cmbEducation.Items[cmbEducation.SelectedIndex].ToString(), cmbGender.Items[cmbGender.SelectedIndex].ToString(),
                cmbHouseOwner.Items[cmbHouseOwner.SelectedIndex].ToString(), cmbMaritalStatus.Items[cmbMaritalStatus.SelectedIndex].ToString(), txtNumberCarsOwned.Text,
                cmbOccupation.Items[cmbOccupation.SelectedIndex].ToString(), cmbRegion.Items[cmbRegion.SelectedIndex].ToString(), txtYearlyIncome.Text);

            if (String.IsNullOrEmpty(cp.Error))
            {
                SetTooltips(cp.Probabilities);

                if (cp.Probabilities.PredictCaseLikelihood * 100 < _min)
                {
                    var cl = new CaseLikelihood(cp.Probabilities.PredictCaseLikelihood, _min);
                    if (DialogResult.Yes == cl.ShowDialog())
                    {
                        #region FINDMINPROB
                        _sProbability = "Age";
                        _dProbability = cp.Probabilities.Age;

                        if (cp.Probabilities.Children < _dProbability)
                        {
                            _sProbability = "ChildrenPar";
                            _dProbability = cp.Probabilities.Children;
                        }
                        if (cp.Probabilities.CommuteDistance < _dProbability)
                        {
                            _sProbability = "CommuteDistance";
                            _dProbability = cp.Probabilities.CommuteDistance;
                        }
                        if (cp.Probabilities.Country < _dProbability)
                        {
                            _sProbability = "Country";
                            _dProbability = cp.Probabilities.Country;
                        }
                        if (cp.Probabilities.Education < _dProbability)
                        {
                            _sProbability = "Education";
                            _dProbability = cp.Probabilities.Education;
                        }
                        if (cp.Probabilities.Gender < _dProbability)
                        {
                            _sProbability = "Gender";
                            _dProbability = cp.Probabilities.Gender;
                        }
                        if (cp.Probabilities.HOF < _dProbability)
                        {
                            _sProbability = "HOF";
                            _dProbability = cp.Probabilities.HOF;
                        }
                        if (cp.Probabilities.MaritalStatus < _dProbability)
                        {
                            _sProbability = "MaritalStatus";
                            _dProbability = cp.Probabilities.MaritalStatus;
                        }
                        if (cp.Probabilities.NumberCarsOwned < _dProbability)
                        {
                            _sProbability = "NumberCarsOwned";
                            _dProbability = cp.Probabilities.NumberCarsOwned;
                        }
                        if (cp.Probabilities.Occupation < _dProbability)
                        {
                            _sProbability = "Occupation";
                            _dProbability = cp.Probabilities.Occupation;
                        }
                        if (cp.Probabilities.Region < _dProbability)
                        {
                            _sProbability = "Region";
                            _dProbability = cp.Probabilities.Region;
                        }
                        if (cp.Probabilities.YearlyIncome < _dProbability)
                        {
                            _sProbability = "YearlyIncome";
                            _dProbability = cp.Probabilities.YearlyIncome;
                        }

                        switch (_sProbability)
                        {
                            case "Age":
                                txtAge.BackColor = Color.Yellow;
                                break;
                            case "ChildrenPar":
                                txtChildren.BackColor = Color.Yellow;
                                break;
                            case "CommuteDistance":
                                cmbCommuteDistance.BackColor = Color.Yellow;
                                break;
                            case "Country":
                                cmbCountry.BackColor = Color.Yellow;
                                break;
                            case "Education":
                                cmbEducation.BackColor = Color.Yellow;
                                break;
                            case "Gender":
                                cmbGender.BackColor = Color.Yellow;
                                break;
                            case "HOF":
                                cmbHouseOwner.BackColor = Color.Yellow;
                                break;
                            case "MaritalStatus":
                                cmbMaritalStatus.BackColor = Color.Yellow;
                                break;
                            case "NumberCarsOwned":
                                txtNumberCarsOwned.BackColor = Color.Yellow;
                                break;
                            case "Occupation":
                                cmbOccupation.BackColor = Color.Yellow;
                                break;
                            case "Region":
                                cmbRegion.BackColor = Color.Yellow;
                                break;
                            case "YearlyIncome":
                                txtYearlyIncome.BackColor = Color.Yellow;
                                break;
                        }
                        #endregion
                    }
                    else
                    {
                        MessageBox.Show("Data has been sent.", "Sent data", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                    }
                }
                else
                {
                    var cl = new CaseLikelihood(cp.Probabilities.PredictCaseLikelihood, _min);
                    if (DialogResult.No == cl.ShowDialog())
                        MessageBox.Show("Data has been sent.", "Sent data", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
                }
            }
            else
                MessageBox.Show(cp.Error);
        }

        private void SetTooltips(CustomerProbability cp)
        {
            lblPAge.Text = Math.Round(cp.Age * 100, 0) + "%";
            lblPChildren.Text = Math.Round(cp.Children * 100, 0) + "%";
            lblPCommuteDistance.Text = Math.Round(cp.CommuteDistance * 100, 0) + "%";
            lblPCountry.Text = Math.Round(cp.Country * 100, 0) + "%";
            lblPEducation.Text = Math.Round(cp.Education * 100, 0) + "%";
            lblPGender.Text = Math.Round(cp.Gender * 100, 0) + "%";
            lblPHouseOwner.Text = Math.Round(cp.HOF * 100, 0) + "%";
            lblPMaritalStatus.Text = Math.Round(cp.MaritalStatus * 100, 0) + "%";
            lblPNumberCars.Text = Math.Round(cp.NumberCarsOwned * 100, 0) + "%";
            lblPOccupation.Text = Math.Round(cp.Occupation * 100, 0) + "%";
            lblPRegion.Text = Math.Round(cp.Region * 100, 0) + "%";
            lblPYearlyIncome.Text = Math.Round(cp.YearlyIncome * 100, 0) + "%";
        }

        private void SetControlsDefaultBackground()
        {
            txtAge.BackColor = Color.White;
            txtChildren.BackColor = Color.White;
            cmbCommuteDistance.BackColor = Color.White;
            cmbCountry.BackColor = Color.White;
            cmbEducation.BackColor = Color.White;
            cmbGender.BackColor = Color.White;
            cmbHouseOwner.BackColor = Color.White;
            cmbMaritalStatus.BackColor = Color.White;
            txtNumberCarsOwned.BackColor = Color.White;
            cmbOccupation.BackColor = Color.White;
            cmbRegion.BackColor = Color.White;
            txtYearlyIncome.BackColor = Color.White;
        }

        private void DataValidation_Load(object sender, EventArgs e)
        {
            var model = new CustomersModelDataContext();

            var countryList = (from cou in model.Customers
                               select cou.Country).Distinct();
            cmbCountry.Items.Add("");
            foreach (var item in countryList)
                cmbCountry.Items.Add(item);

            var maritalStatusList = (from mar in model.Customers
                                     select mar.MaritalStatus).Distinct();
            cmbMaritalStatus.Items.Add("");
            foreach (var item in maritalStatusList)
                cmbMaritalStatus.Items.Add(item);

            var educationList = (from edu in model.Customers
                                 select edu.Education).Distinct();
            cmbEducation.Items.Add("");
            foreach (var item in educationList)
                cmbEducation.Items.Add(item);

            var occupationList = (from occ in model.Customers
                                  select occ.Occupation).Distinct();
            cmbOccupation.Items.Add("");
            foreach (var item in occupationList)
                cmbOccupation.Items.Add(item);

            var houseOwnerList = (from hou in model.Customers
                                  select hou.HouseOwnerFlag).Distinct();
            cmbHouseOwner.Items.Add("");
            foreach (var item in houseOwnerList)
                cmbHouseOwner.Items.Add(item);

            var commuteDistance = (from com in model.Customers
                                   select com.CommuteDistance).Distinct();
            cmbCommuteDistance.Items.Add("");
            foreach (var item in commuteDistance)
                cmbCommuteDistance.Items.Add(item);

            var regionList = (from reg in model.Customers
                              select reg.Region).Distinct();
            cmbRegion.Items.Add("");
            foreach (var item in regionList)
                cmbRegion.Items.Add(item);

            var genderList = (from gen in model.Customers
                              select gen.Gender).Distinct();
            cmbGender.Items.Add("");
            foreach (var item in genderList)
                cmbGender.Items.Add(item);

            trackBarPercent.Value = 15;
            _min = trackBarPercent.Value;
            lblPercent.Text = trackBarPercent.Value.ToString();
        }

        private void trackBarPercent_Scroll(object sender, EventArgs e)
        {
            _min = trackBarPercent.Value;
            lblPercent.Text = trackBarPercent.Value.ToString();
        }
    }
}
