﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media.Imaging;
using Microsoft.Windows.Controls.Ribbon;
using Helpers;

namespace AdaptiveInterfaceDemo
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class AdaptiveInterface : RibbonWindow
    {
        private bool _train = true;
        private readonly List<Seq> _seqList = new List<Seq>();
        private short _position = 1;

        private RibbonButton _rb1;
        private RibbonButton _rb2;
        private RibbonButton _rb3;
        private RibbonButton _rb4;
        private RibbonButton _rb5;
        private RibbonButton _rb6;
        private RibbonButton _rb7;
        private RibbonButton _rb8;
        private RibbonButton _rb9;
        private RibbonButton _rb10;

        private bool _first = true;
        private bool _send;

        public AdaptiveInterface()
        {
            InitializeComponent();
        }

        private void LayoutRoot_Loaded(object sender, RoutedEventArgs e)
        {
            DatabaseHelper.ClearModel();
            btnInsert.IsEnabled = _train;
        }

        private void btnTrain_Click(object sender, RoutedEventArgs e)
        {
            // Make this operations in other thread
            if (_train)
            {
                var s = DatabaseHelper.Train();
                if (!String.IsNullOrEmpty(s))
                    MessageBox.Show(s);
                else
                {
                    _train = btnInsert.IsEnabled = false;
                    var predictions = DatabaseHelper.GetDefaultButton();
                    if (!String.IsNullOrEmpty(predictions.Error))
                        MessageBox.Show(predictions.Error);
                    else
                    {
                        LoadButtons(predictions.Prediction);
                        btnGo.IsEnabled = btnSend.IsEnabled = !_train;
                        btnTraining.Label = "Stop";
                    }
                }
            }
            else
            {
                var s = DatabaseHelper.ClearModel();
                if (!String.IsNullOrEmpty(s))
                    MessageBox.Show(s);
                else
                {
                    _train = btnInsert.IsEnabled = true;
                    btnGo.IsEnabled = btnSend.IsEnabled = !_train;
                    btnTraining.Label = "Train";
                    var biLarge = new BitmapImage();
                    biLarge.BeginInit();
                    biLarge.UriSource = new Uri("Images\\LargeIconClean.png", UriKind.Relative);
                    biLarge.EndInit();
                    btnSend.LargeImageSource = biLarge;
                    outputList.Items.Clear();
                    ReloadButtons();
                    AddButtonsToGroup();
                }
            }
        }

        private void LoadButtons(IEnumerable<Prediction> list)
        {
            ReloadButtons();

            foreach (var item in list)
            {
                BitmapImage biLarge;

                if (item.ProbToLeave - item.Expression < 0.3)
                {
                    switch (item.Button)
                    {
                        case 'A':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconABlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb1.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconA.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb1.LargeImageSource = biLarge;
                            }
                            break;
                        case 'B':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconBBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb2.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconB.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb2.LargeImageSource = biLarge;
                            }
                            break;
                        case 'C':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconCBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb3.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconC.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb3.LargeImageSource = biLarge;
                            }
                            break;
                        case 'D':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconDBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb4.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconD.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb4.LargeImageSource = biLarge;
                            }
                            break;
                        case 'E':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconEBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb5.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconE.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb5.LargeImageSource = biLarge;
                            }
                            break;
                        case 'F':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconFBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb6.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconF.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb6.LargeImageSource = biLarge;
                            }
                            break;
                        case 'G':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconGBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb7.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconG.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb7.LargeImageSource = biLarge;
                            }
                            break;
                        case 'H':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconHBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb8.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconH.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb8.LargeImageSource = biLarge;
                            }
                            break;
                        case 'I':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconIBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb9.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconI.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb9.LargeImageSource = biLarge;
                            }
                            break;
                        case 'J':
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconJBlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb10.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconJ.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb10.LargeImageSource = biLarge;
                            }
                            break;
                        default:
                            if (_first)
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconABlack.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb1.LargeImageSource = biLarge;
                                _first = false;
                            }
                            else
                            {
                                biLarge = new BitmapImage();
                                biLarge.BeginInit();
                                biLarge.UriSource = new Uri("Images\\LargeIconA.png", UriKind.Relative);
                                biLarge.EndInit();
                                _rb1.LargeImageSource = biLarge;
                            }
                            break;
                    }
                }
                else
                {
                    biLarge = new BitmapImage();
                    biLarge.BeginInit();
                    biLarge.UriSource = new Uri("Images\\LargeIconCleanBlack.png", UriKind.Relative);
                    biLarge.EndInit();
                    btnSend.LargeImageSource = biLarge;
                    _send = true;
                }

                outputList.Items.Add(String.Format("{0}: Button: {1}; Probability: {2}; ProbToLeave: {3}", item.Sequence, item.Button, item.Expression, item.ProbToLeave));
            }

            outputList.Items.Add("***************************************************************************************");
            _first = true;
            AddButtonsToGroup();
        }

        private void AddButtonsToGroup()
        {
            Group1.Items.Add(_rb1);
            Group1.Items.Add(_rb2);
            Group1.Items.Add(_rb3);
            Group1.Items.Add(_rb4);
            Group1.Items.Add(_rb5);
            Group1.Items.Add(_rb6);
            Group1.Items.Add(_rb7);
            Group1.Items.Add(_rb8);
            Group1.Items.Add(_rb9);
            Group1.Items.Add(_rb10);
        }

        private void ReloadButtons()
        {
            Group1.Items.Clear();

            var biSmallA = new BitmapImage();
            biSmallA.BeginInit();
            biSmallA.UriSource = new Uri("Images\\SmallIconA.png", UriKind.Relative);
            biSmallA.EndInit();

            _rb1 = new RibbonButton {Label = "A", SmallImageSource = biSmallA};
            _rb1.Click += btnAddSeq_Click;

            var biSmallB = new BitmapImage();
            biSmallB.BeginInit();
            biSmallB.UriSource = new Uri("Images\\SmallIconB.png", UriKind.Relative);
            biSmallB.EndInit();

            _rb2 = new RibbonButton {Label = "B", SmallImageSource = biSmallB};
            _rb2.Click += btnAddSeq_Click;

            var biSmallC = new BitmapImage();
            biSmallC.BeginInit();
            biSmallC.UriSource = new Uri("Images\\SmallIconC.png", UriKind.Relative);
            biSmallC.EndInit();

            _rb3 = new RibbonButton {Label = "C", SmallImageSource = biSmallC};
            _rb3.Click += btnAddSeq_Click;

            var biSmallD = new BitmapImage();
            biSmallD.BeginInit();
            biSmallD.UriSource = new Uri("Images\\SmallIconD.png", UriKind.Relative);
            biSmallD.EndInit();

            _rb4 = new RibbonButton {Label = "D", SmallImageSource = biSmallD};
            _rb4.Click += btnAddSeq_Click;

            var biSmallE = new BitmapImage();
            biSmallE.BeginInit();
            biSmallE.UriSource = new Uri("Images\\SmallIconE.png", UriKind.Relative);
            biSmallE.EndInit();

            _rb5 = new RibbonButton {Label = "E", SmallImageSource = biSmallE};
            _rb5.Click += btnAddSeq_Click;

            var biSmallF = new BitmapImage();
            biSmallF.BeginInit();
            biSmallF.UriSource = new Uri("Images\\SmallIconF.png", UriKind.Relative);
            biSmallF.EndInit();

            _rb6 = new RibbonButton {Label = "F", SmallImageSource = biSmallF};
            _rb6.Click += btnAddSeq_Click;

            var biSmallG = new BitmapImage();
            biSmallG.BeginInit();
            biSmallG.UriSource = new Uri("Images\\SmallIconG.png", UriKind.Relative);
            biSmallG.EndInit();

            _rb7 = new RibbonButton {Label = "G", SmallImageSource = biSmallG};
            _rb7.Click += btnAddSeq_Click;

            var biSmallH = new BitmapImage();
            biSmallH.BeginInit();
            biSmallH.UriSource = new Uri("Images\\SmallIconH.png", UriKind.Relative);
            biSmallH.EndInit();

            _rb8 = new RibbonButton {Label = "H", SmallImageSource = biSmallH};
            _rb8.Click += btnAddSeq_Click;

            var biSmallI = new BitmapImage();
            biSmallI.BeginInit();
            biSmallI.UriSource = new Uri("Images\\SmallIconI.png", UriKind.Relative);
            biSmallI.EndInit();

            _rb9 = new RibbonButton {Label = "I", SmallImageSource = biSmallI};
            _rb9.Click += btnAddSeq_Click;

            var biSmallJ = new BitmapImage();
            biSmallJ.BeginInit();
            biSmallJ.UriSource = new Uri("Images\\SmallIconJ.png", UriKind.Relative);
            biSmallJ.EndInit();

            _rb10 = new RibbonButton {Label = "J", SmallImageSource = biSmallJ};
            _rb10.Click += btnAddSeq_Click;
        }

        private void btnInsert_Click(object sender, RoutedEventArgs e)
        {
            if (_seqList.Count > 0)
            {
                DatabaseHelper.InsertSeqList(_seqList);
                ClearSeq();
            }
        }

        private void ClearSeq()
        {
            _seqList.Clear();
            _position = 1;
        }

        private void btnAddSeq_Click(object sender, RoutedEventArgs e)
        {
            var seq = new Seq { Position = _position, Button = ((RibbonButton)sender).Label.ToCharArray().First() };
            _seqList.Add(seq);
            _position++;
        }

        private void btnGo_Click(object sender, RoutedEventArgs e)
        {
            GetButtons();
        }

        private void GetButtons()
        {
            if (_seqList.Count == 0)
            {
                var predictions = DatabaseHelper.GetDefaultButton();
                if (!String.IsNullOrEmpty(predictions.Error))
                    MessageBox.Show(predictions.Error);
                else
                    LoadButtons(predictions.Prediction);
            }
            else
            {
                var predictions = DatabaseHelper.GetButtons(_seqList);
                if (!String.IsNullOrEmpty(predictions.Error))
                    MessageBox.Show(predictions.Error);
                else
                    LoadButtons(predictions.Prediction);
            }
        }

        private void btnSend_Click(object sender, RoutedEventArgs e)
        {
            Send();
        }

        private void Send()
        {
            _seqList.Clear();
            var biLarge = new BitmapImage();
            biLarge.BeginInit();
            biLarge.UriSource = new Uri("Images\\LargeIconClean.png", UriKind.Relative);
            biLarge.EndInit();
            btnSend.LargeImageSource = biLarge;
            outputList.Items.Clear();
            var predictions = DatabaseHelper.GetDefaultButton();
            if (!String.IsNullOrEmpty(predictions.Error))
                MessageBox.Show(predictions.Error);
            else
                LoadButtons(predictions.Prediction);
            _send = false;
        }

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (!_train && !_send && e.Key == Key.Space)
            {
                GetButtons();
            }
            else if (!_train && _send && e.Key == Key.Space)
            {
                Send();
            }
        }
    }
}
