---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Rozdział 19. Przykłady z kodem
----------------------------------------------------------------------------

-- POLECENIE VACUUM

-- Listing 19.1: Tworzenie tabeli w celu przetestowania procesu opróżniania

CREATE TABLE vacuum_test (
    integer_column integer
);

-- Listing 19.2: Określanie rozmiaru tabeli vacuum_test

SELECT pg_size_pretty(
           pg_total_relation_size('vacuum_test')
       );

-- opcjonalne: Określanie rozmiaru bazy danych   
SELECT pg_size_pretty(
           pg_database_size('analysis')
       );

-- Listing 19.3: Wstawianie 500 000 wierszy do tabeli vacuum_test

INSERT INTO vacuum_test
SELECT * FROM generate_series(1,500000);

-- Ponowne sprawdzenie wielkości
SELECT pg_size_pretty(
           pg_table_size('vacuum_test')
       );

-- Listing 19.4: Aktualizowanie wszystkich wierszy tabeli vacuum_test

UPDATE vacuum_test
SET integer_column = integer_column + 1;

-- Ponowne sprawdzenie wielkości (35 MB)
SELECT pg_size_pretty(
           pg_table_size('vacuum_test')
       );

-- Listing 19.5: Wyświetlanie w przypadku tabeli vacuum_test statystyk dotyczących procesu automatycznego opróżniania

SELECT relname,
       last_vacuum,
       last_autovacuum,
       vacuum_count,
       autovacuum_count
FROM pg_stat_all_tables
WHERE relname = 'vacuum_test';

-- Wyświetlenie wszystkich dostępnych tabel
SELECT *
FROM pg_stat_all_tables
WHERE relname = 'vacuum_test';

-- Listing 19.6: Ręczne uruchamianie polecenia VACUUM

VACUUM vacuum_test;

VACUUM; -- usunięcie całej bazy danych

VACUUM VERBOSE; -- zapewnienie komunikatów

-- Listing 19.7: Użycie polecenia VACUUM FULL do odzyskania przestrzeni dyskowej

VACUUM FULL vacuum_test;

-- Ponowne sprawdzenie wielkości
SELECT pg_size_pretty(
           pg_table_size('vacuum_test')
       );
       
-- USTAWIENIA

-- Listing 19.8: Wyświetlanie lokalizacji pliku postgresql.conf

SHOW config_file;

-- Listing 19.9: Przykładowe ustawienia z pliku postgresql.conf

-- Listing 19.10: Wyświetlanie położenia katalogu danych

SHOW data_directory;

-- Ponowne wczytanie ustawień za pomocą polecenia pg_ctl:
-- Mac i Linux: pg_ctl reload -D '/sciezka/katalogu/danych/'
-- Windows: pg_ctl reload -D "C:\sciezka\katalogu\danych\"

-- Ponowne wczytanie ustawień za pomocą polecenia pg_reload_conf():
-- SELECT pg_reload_conf(); 


-- KOPIE ZAPASOWE I PRZYWRACANIE DANYCH

-- Listing 19.11: Eksportowanie bazy danych analysis za pomocą narzędzia pg_dump
pg_dump -d analysis -U [nazwa_użytkownika] -Fc -v -f analysis_backup.dump

-- Eksportowanie jedynie tabeli
pg_dump -t 'train_rides' -d analysis -U [nazwa_użytkownika] -Fc -v -f train_backup.dump

-- Listing 19.12: Przywracanie bazy danych analysis za pomocą narzędzia pg_restore

pg_restore -C -d postgres -U postgres analysis_backup.dump