---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Rozdział 10. Przykłady z kodem
----------------------------------------------------------------------------

-- Listing 10.1: Importowanie katalogu agencji FSIS prowadzącej inspekcję producentów mięsa, drobiu i jaj
-- https://catalog.data.gov/dataset/fsis-meat-poultry-and-egg-inspection-directory-by-establishment-name

CREATE TABLE meat_poultry_egg_establishments (
    establishment_number text CONSTRAINT est_number_key PRIMARY KEY,
    company text,
    street text,
    city text,
    st text,
    zip text,
    phone text,
    grant_date date,
    activities text,
    dbas text
);

COPY meat_poultry_egg_establishments
FROM 'C:\TwojKatalog\MPI_Directory_by_Establishment_Name.csv'
WITH (FORMAT CSV, HEADER);

CREATE INDEX company_idx ON meat_poultry_egg_establishments (company);

-- Ustalenie liczby zaimportowanych wierszy:
SELECT count(*) FROM meat_poultry_egg_establishments;

-- Listing 10.2: Znajdowanie wielu firm o tym samym adresie
SELECT company,
       street,
       city,
       st,
       count(*) AS address_count
FROM meat_poultry_egg_establishments
GROUP BY company, street, city, st
HAVING count(*) > 1
ORDER BY company, street, city, st;

-- Listing 10.3: Grupowanie stanów i ustalanie ich liczby
SELECT st, 
       count(*) AS st_count
FROM meat_poultry_egg_establishments
GROUP BY st
ORDER BY st;

-- Listing 10.4: Użycie słów kluczowych IS NULL do zidentyfikowania w kolumnie st brakujących wartości
SELECT establishment_number,
       company,
       city,
       st,
       zip
FROM meat_poultry_egg_establishments
WHERE st IS NULL;

-- Listing 10.5: Zastosowanie klauzuli GROUP BY i funkcji count() do znalezienia niespójnych nazw firm

SELECT company,
       count(*) AS company_count
FROM meat_poultry_egg_establishments
GROUP BY company
ORDER BY company ASC;

-- Listing 10.6: Zastosowanie funkcji length() i count() do sprawdzenia kolumny zip

SELECT length(zip),
       count(*) AS length_count
FROM meat_poultry_egg_establishments
GROUP BY length(zip)
ORDER BY length(zip) ASC;

-- Listing 10.7: Filtrowanie za pomocą funkcji length() w celu znalezienia skróconych wartości kodu pocztowego

SELECT st,
       count(*) AS st_count
FROM meat_poultry_egg_establishments
WHERE length(zip) < 5
GROUP BY st
ORDER BY st ASC;

-- Listing 10.8: Tworzenie kopii zapasowej tabeli

CREATE TABLE meat_poultry_egg_establishments_backup AS
SELECT * FROM meat_poultry_egg_establishments;

-- Sprawdzenie liczby rekordów:
SELECT 
    (SELECT count(*) FROM meat_poultry_egg_establishments) AS original,
    (SELECT count(*) FROM meat_poultry_egg_establishments_backup) AS backup;

-- Listing 10.9: Tworzenie i wypełnianie kolumny st_copy danymi za pomocą instrukcji ALTER TABLE i UPDATE

ALTER TABLE meat_poultry_egg_establishments ADD COLUMN st_copy text;

UPDATE meat_poultry_egg_establishments
SET st_copy = st;

-- Listing 10.10: Sprawdzanie wartości w kolumnach st i st_copy

SELECT st,
       st_copy
FROM meat_poultry_egg_establishments
WHERE st IS DISTINCT FROM st_copy
ORDER BY st;

-- Listing 10.11: Aktualizowanie kolumny st w przypadku trzech placówek

UPDATE meat_poultry_egg_establishments
SET st = 'MN'
WHERE establishment_number = 'V18677A';

UPDATE meat_poultry_egg_establishments
SET st = 'AL'
WHERE establishment_number = 'M45319+P45319';

UPDATE meat_poultry_egg_establishments
SET st = 'WI'
WHERE establishment_number = 'M263A+P263A+V263A'
RETURNING establishment_number, company, city, st, zip;

-- Listing 10.12: Przywracanie oryginalnych wartości kolumny st

-- Przywracanie z kopii zapasowej kolumn
UPDATE meat_poultry_egg_establishments
SET st = st_copy;

-- Przywracanie z kopii zapasowej tabel
UPDATE meat_poultry_egg_establishments original
SET st = backup.st
FROM meat_poultry_egg_establishments_backup backup
WHERE original.establishment_number = backup.establishment_number; 

-- Listing 10.13: Tworzenie kolumny company_standard i wypełnianie jej danymi

ALTER TABLE meat_poultry_egg_establishments ADD COLUMN company_standard text;

UPDATE meat_poultry_egg_establishments
SET company_standard = company;

-- Listing 10.14: Zastosowanie instrukcji UPDATE do zmodyfikowania wartości kolumny pasujące do określonego łańcucha

UPDATE meat_poultry_egg_establishments
SET company_standard = 'Armour-Eckrich Meats'
WHERE company LIKE 'Armour%'
RETURNING company, company_standard;

-- Listing 10.15: Tworzenie kolumny zip_copy i wypełnianie jej danymi

ALTER TABLE meat_poultry_egg_establishments ADD COLUMN zip_copy text;

UPDATE meat_poultry_egg_establishments
SET zip_copy = zip;

-- Listing 10.16: Modyfikowanie kodów w kolumnie zip z brakującymi dwoma początkowymi zerami

UPDATE meat_poultry_egg_establishments
SET zip = '00' || zip
WHERE st IN('PR','VI') AND length(zip) = 3;

-- Listing 10.17: Modyfikowanie kodów w kolumnie zip z jednym brakującym początkowym zerem

UPDATE meat_poultry_egg_establishments
SET zip = '0' || zip
WHERE st IN('CT','MA','ME','NH','NJ','RI','VT') AND length(zip) = 4;

-- Listing 10.18: Tworzenie tabeli state_regions i wypełnianie jej danymi

CREATE TABLE state_regions (
    st text CONSTRAINT st_key PRIMARY KEY,
    region text NOT NULL
);

COPY state_regions
FROM 'C:\TwojKatalog\state_regions.csv'
WITH (FORMAT CSV, HEADER);

-- Listing 10.19: Dodawanie i aktualizowanie kolumny inspection_deadline

ALTER TABLE meat_poultry_egg_establishments
    ADD COLUMN inspection_deadline timestamp with time zone;

UPDATE meat_poultry_egg_establishments establishments
SET inspection_deadline = '2022-12-01 00:00 EST'
WHERE EXISTS (SELECT state_regions.region
              FROM state_regions
              WHERE establishments.st = state_regions.st 
                    AND state_regions.region = 'New England');

-- Listing 10.20: Wyświetlanie zaktualizowanych wartości kolumny inspection_date

SELECT st, inspection_deadline
FROM meat_poultry_egg_establishments
GROUP BY st, inspection_deadline
ORDER BY st;

-- Listing 10.21: Usuwanie wierszy zgodnych w wyrażeniem

DELETE FROM meat_poultry_egg_establishments
WHERE st IN('AS','GU','MP','PR','VI');

-- Listing 10.22: Usuwanie kolumny z tabeli za pomocą instrukcji DROP

ALTER TABLE meat_poultry_egg_establishments DROP COLUMN zip_copy;

-- Listing 10.23: Usuwanie tabeli z bazy danych za pomocą instrukcji DROP

DROP TABLE meat_poultry_egg_establishments_backup;

-- Listing 10.24: Demonstracja zastosowania bloku transakcji

-- Rozpoczęcie transakcji i wykonanie aktualizacji
START TRANSACTION;

UPDATE meat_poultry_egg_establishments
SET company = 'AGRO Merchantss Oakland LLC'
WHERE company = 'AGRO Merchants Oakland, LLC';

-- Wyświetlenie zmian
SELECT company
FROM meat_poultry_egg_establishments
WHERE company LIKE 'AGRO%'
ORDER BY company;

-- Cofnięcie zmian
ROLLBACK;

-- Wyświetlenie przywróconego stanu
SELECT company
FROM meat_poultry_egg_establishments
WHERE company LIKE 'AGRO%'
ORDER BY company;

-- Alternatywnie, zatwierdzenie zmian na końcu:
START TRANSACTION;

UPDATE meat_poultry_egg_establishments
SET company = 'AGRO Merchants Oakland LLC'
WHERE company = 'AGRO Merchants Oakland, LLC';

COMMIT;

-- Listing 10.25: Tworzenie kopii zapasowej tabeli w trakcie dodawania i wypełniania nowej kolumny

CREATE TABLE meat_poultry_egg_establishments_backup AS
SELECT *,
       '2023-02-14 00:00 EST'::timestamp with time zone AS reviewed_date
FROM meat_poultry_egg_establishments;

-- Listing 10.26: Zamiana nazw tabel za pomocą instrukcji ALTER TABLE

ALTER TABLE meat_poultry_egg_establishments 
    RENAME TO meat_poultry_egg_establishments_temp;
ALTER TABLE meat_poultry_egg_establishments_backup 
    RENAME TO meat_poultry_egg_establishments;
ALTER TABLE meat_poultry_egg_establishments_temp 
    RENAME TO meat_poultry_egg_establishments_backup;


