---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Rozdział 4. Przykłady z kodem
----------------------------------------------------------------------------

-- Listing 4.1: Zastosowanie znakowych typów danych

CREATE TABLE char_data_types (
    char_column char(10),
    varchar_column varchar(10),
    text_column text
);

INSERT INTO char_data_types
VALUES
    ('abc', 'abc', 'abc'),
    ('defghi', 'defghi', 'defghi');

COPY char_data_types TO 'C:\TwojKatalog\typetest.txt'
WITH (FORMAT CSV, HEADER, DELIMITER '|');


-- Listing 4.2: Użycie liczbowych typów danych

CREATE TABLE number_data_types (
    numeric_column numeric(20,5),
    real_column real,
    double_column double precision
);

INSERT INTO number_data_types
VALUES
    (.7, .7, .7),
    (2.13579, 2.13579, 2.13579),
    (2.1357987654, 2.1357987654, 2.1357987654);

SELECT * FROM number_data_types;

-- Listing 4.3: Kwestie zaokrąglania związane z kolumnami typu zmiennoprzecinkowego
-- Przyjęto, że tabelę utworzono i załadowano za pomocą kodu z listingu 4.2

SELECT
    numeric_column * 10000000 AS fixed,
    real_column * 10000000 AS floating
FROM number_data_types
WHERE numeric_column = .7;

-- Listing 4.4: Zastosowanie typów timestamp with time zone i interval

CREATE TABLE date_time_types (
    timestamp_column timestamp with time zone,
    interval_column interval
);

INSERT INTO date_time_types
VALUES
    ('2022-12-31 01:00 EST','2 days'),
    ('2022-12-31 01:00 -8','1 month'),
    ('2022-12-31 01:00 Australia/Melbourne','1 century'),
    (now(),'1 week');

SELECT * FROM date_time_types;

-- Listing 4.5: Zastosowanie typu danych interval
-- Przyjęto, że uruchomiono skrypt 4.4

SELECT
    timestamp_column,
    interval_column,
    timestamp_column - interval_column AS new_date
FROM date_time_types;

-- Listing 4.6: Trzy przykłady użycia funkcji CAST()

SELECT timestamp_column, CAST(timestamp_column AS varchar(10))
FROM date_time_types;

SELECT numeric_column,
       CAST(numeric_column AS integer),
       CAST(numeric_column AS text)
FROM number_data_types;

-- Nie działa:
SELECT CAST(char_column AS integer) FROM char_data_types;

-- Alternatywna notacja dla funkcji CAST to podwójny dwukropek:
SELECT timestamp_column::varchar(10)
FROM date_time_types;
