drop table wycieczki;
drop table wodospady;
drop table jedn_terytorialne;
drop table wlasciciele;
drop table przestawna;
drop table przyklad_db2;
drop table przyklad_nadrzednej;
drop table gminy;
drop table hrabstwa;
drop table stany;
drop table lokalizacje_wodospadow;
drop table opisy_wodospadow;
drop table nowe_wodospady;
drop table inne_jednostki;
drop table dual;

create table jedn_terytorialne (
	id		integer NOT NULL,
	id_nadrzednej	integer DEFAULT 3,
	nazwa		varchar(10),
	typ		varchar(8),
	constraint jedn_terytorialne__pk 
		primary key (id),
	constraint jedn_terytorialne_spr
		check (type in ('hrabstwo','gmina','miasto','stan')),
        constraint jedn_terytorialne_petla
                foreign key (id_nadrzednej)
                references jedn_terytorialne
	);

create table gminy (
	id		integer,
	nazwa		varchar(10),
	ludnosc	integer
        );

create view male_gminy as
   select * from gminy 
   where ludnosc < 500;
   
create table hrabstwa (
	id		integer not null,
	nazwa		varchar(10),
	ludnosc	integer,
        constraint hrabstwa_pk
           primary key (id)
        );

create table stany (
	id		integer,
	nazwa		varchar(10),
	ludnosc	integer
        );
		
create table inne_jednostki (
	id		integer,
	nazwa		varchar(10),
	ludnosc	integer
        );

create table wlasciciele (
	id		integer not null,
	nazwa	varchar(15),
	telefon		varchar(12),
	typ		varchar(9),
	constraint wlasciciele_pk
		primary key (id),
	constraint wlasciciele_typ_spr
		check (typ in ('publiczny','prywatny'))
	);
		
create table wodospady (
	id		integer not null,
	nazwa		varchar(15),
	kod_lokalizacji		varchar(7),
	strefa		integer,
	szerokosc	integer,
	dlugosc		integer,
	koordynaty		varchar(20), 
	id_hrabstwa	integer,
	publicznie_dostepne	varchar(1),
	id_wlasciciela	integer,
	opis	varchar(100),
	data_potwierdzenia	timestamp,
	constraint wodospady_pk
		primary key (id),
	constraint publicznie_dostepne_spr
		check (publicznie_dostepne in ('t','n')),
	constraint id_wlasciciela_fk
		foreign key (id_wlasciciela)
		references wlasciciele,
	constraint id_jedn_terytorialnej
		foreign key (id_hrabstwa)
		references hrabstwa
	);
		
create table lokalizacje_wodospadow (
	id		integer,
	kod_lokalizacji		varchar(7),
	strefa		integer,
	szerokosc	integer,
	dlugosc		integer
        );

create table opisy_wodospadow (
	id		integer,
	nazwa		varchar(15),
	opis	varchar(100)
        );
		
create table nowe_wodospady (
	id		integer,
	nazwa		varchar(15),
	kod_lokalizacji		varchar(7),
	strefa		integer,
	szerokosc	integer,
	dlugosc		integer,
	koordynaty		varchar(20), 
	id_hrabstwa	integer,
	publicznie_dostepne	varchar(1),
	id_wlasciciela	integer,
	opis	varchar(80),
	data_potwierdzenia	datetime
        );

create table wycieczki (
	nazwa		varchar(10) not null,
	przystanek		integer not null,
	przystanek_poprzedni	integer,
	constraint wycieczki_pk
		primary key (nazwa, przystanek),
	constraint przystanek_poprzedni_fk
		foreign key (nazwa, przystanek_poprzedni)
		references wycieczki,
        constraint wycieczki_fk
                foreign key (przystanek) 
                references wodospady
	);
		
CREATE TABLE przestawna (
   x integer
   );

CREATE TABLE przyklad_nadrzednej (
   nazwa varchar(15) not null,
   kraj varchar(2) not null DEFAULT 'CA' 
      CONSTRAINT przyklad_nadrzednej_kraj 
      CHECK (kraj IN ('CA','US')),
   CONSTRAINT przyklad_nadrzednej_pk
      PRIMARY KEY(nazwa, kraj)
);

create table dual (
   nieistotne varchar(1)
);

insert into dual values ('X');
   
insert into jedn_terytorialne values (3,null,'Michigan','stan');
insert into jedn_terytorialne values (2,3,'Alger','hrabstwo');
insert into jedn_terytorialne values (1,2,'Munising','miasto');
insert into jedn_terytorialne values (4,2,'Munising','gmina');
insert into jedn_terytorialne values (5,2,'Au Train','gmina');
insert into jedn_terytorialne values (6,3,'Baraga','hrabstwo');
insert into jedn_terytorialne values (7,3,'Ontonagon','hrabstwo');
insert into jedn_terytorialne values (8,7,'Interior','gmina');
insert into jedn_terytorialne values (9,3,'Dickinson','hrabstwo');
insert into jedn_terytorialne values (10,3,'Gogebic','hrabstwo');
insert into jedn_terytorialne values (11,3,'Delta','hrabstwo');
insert into jedn_terytorialne values (12,11,'Masonville','gmina');

insert into gminy values (4,'Munising',3125);
insert into gminy values (5,'Au Train',1172);
insert into gminy values (8,'Interior',375);
insert into gminy values (12,'Masonville',1877);

insert into hrabstwa values (2,'Alger',9862);
insert into hrabstwa values (6,'Baraga',8746);
insert into hrabstwa values (7,'Ontonagon',7818);
insert into hrabstwa values (9,'Dickinson',27472);
insert into hrabstwa values (10,'Gogebic',17370);
insert into hrabstwa values (11,'Delta',38520);

insert into stany values (20, 'Montana', 902195);
insert into stany values (21, 'N. Dakota', null);
insert into stany values (3, 'Michigan', 9938444);

insert into wlasciciele values (1,'Pictured Rocks','906.387.2607','publiczny');
insert into wlasciciele values (2,'Michigan Nature','517.655.5655','prywatny');
insert into wlasciciele values (3,'AF LLC',null,'prywatny');
insert into wlasciciele values (4,'MI DNR','906-228-6561','publiczny');
insert into wlasciciele values (5,'Horseshoe Falls','906.387.2635','prywatny');

insert into wodospady values (1,'Munising Falls','NAD1927',16,5141184,0528971,null,2,'t',1,
                               'Wodospad, ktry da nazw miejscowoci; wystpuje na wszystkich widokwkach',
                               '2005-12-08 19:30:00');
insert into wodospady values (2,'Tannery Falls','NAD1927',16,5140000,0528808,null,2,'t',2,
                               'Podobny do Munising Falls, ale mniej popularny',
                               '2005-12-08 19:50:00');
insert into wodospady values (3,'Alger Falls','NAD1927',16,5137795,0527046,null,2,'t',3,
                               'adny wodospad zlokalizowany we wschodniej czsci miasta',
                               '2005-12-08 20:03:00');
insert into wodospady values (4,'Wagner Falls','NAD1927',16,5137310,0526989,null,2,'t',4,
                               'Niewielki, malowniczy wodospad w pobliu skrzyowania drg M-28 i M-94',
                               '2005-12-08 20:04:00');
insert into wodospady values (5,'Horseshoe Falls','NAD1927',16,5138877,0527323,null,2,'t',null,
                               'Wodospad, park, cieki spacerowe i staw z rybami. Dzieci mog karmi ryby.',
                               '2005-12-08 20:07:00');
insert into wodospady values (6,'Miners Falls',null,null,null,null,null,2,'t',1,
                               'Najwyszy wodpospad w Pictured Rocks.',
                               '2005-12-08 20:10:00');
insert into wodospady values (7,'Little Miners',null,null,null,null,null,2,'t',1,
                               'Malownicze miejsce na rzece Little Miners; dojcie trzy kilometry przez las',
                               '2005-12-08 20:15:00');
insert into wodospady values (8,'Scott Falls',null,null,null,null,null,2,'t',null,
                               'Malownicze przydrone wodospady niedaleko Face on the Rock',
                               '2005-12-18 21:28:00');
insert into wodospady values (9,'Canyon Falls',null,null,null,null,null,6,'t',null,
                               'Kilka kilometrw na pnoc od M-28 (trzy kilometry na poudnie od Alberta), ale warty zobaczenia',
                               '2005-12-18 21:35:00');
insert into wodospady values (10,'Agate Falls',null,null,null,null,null,7,'t',null,
                               'Dojazd drog od Joseph F. Oravec Roadside Park',
                               '2005-12-18 21:35:00');
insert into wodospady values (11,'Bond Falls',null,null,null,null,null,7,'t',null,
                               'Bond Falls Basin, 13 kilometrw na poudnie od Bruce Crossing',
                               '2005-12-18 21:50:00');
insert into wodospady values (12,'Fumee Falls',null,null,null,null,null,9,'t',null,
                               'Start w Helen Z. Lien Roadside Park, pic kilometrw na zachd od Norway',
                               '2005-12-18 21:56:30');
insert into wodospady values (13,'Kakabika Falls',null,null,null,null,null,10,'t',null,
                               'Kilometr na pnoc od autostrady US-2 drog lokaln nr 527',
                               '2005-12-18 22:03:09');
insert into wodospady values (14,'Rapid River Fls',null,null,null,null,null,11,'t',null,
                               'W okolicy s place zabaw, miejsca do biwakowania i stoy piknikowe.',
                               '2005-12-18 22:13:11');
insert into wodospady values (30,'Twin Falls 1','NAD1927',16,5140500,0528641,null,2,'t',2,
                              'W pobliu Twin Falls 2',
                              '2006-02-10 19:35:00');
insert into wodospady values (31,'Twin Falls 2','NAD1927',16,5140500,0528663,null,2,'t',2,
                              'W pobliu Falls 1',
                              '2006-02-10 19:35:00');

insert into nowe_wodospady values (2,'Olson Falls',null,null,null,null,null,2,'t',2,
                               'Podobny do Munising Falls, ale mniej popularny',
                               '2005-12-08 19:50:00');
insert into nowe_wodospady values (20,'MNA Memorial',null,null,null,null,null,2,'t',2,
                               'Tu obok Tannery Falls',
                               '2006-01-31 09:54:00');

insert into wycieczki values ('Munising',1,null);
insert into wycieczki values ('Munising',2,1);
insert into wycieczki values ('Munising',6,2);
insert into wycieczki values ('Munising',4,6);
insert into wycieczki values ('Munising',3,4);
insert into wycieczki values ('Munising',5,3);
insert into wycieczki values ('M-28',3,null);
insert into wycieczki values ('M-28',1,3);
insert into wycieczki values ('M-28',8,1);
insert into wycieczki values ('M-28',9,8);
insert into wycieczki values ('M-28',10,9);
insert into wycieczki values ('M-28',11,10);
insert into wycieczki values ('US-2',14,null);
insert into wycieczki values ('US-2',12,14);
insert into wycieczki values ('US-2',11,12);
insert into wycieczki values ('US-2',13,11);

INSERT INTO przestawna
SELECT setki.x+dziesiatki.x+jednosci.x FROM
  (SELECT 0 x FROM dual
   UNION ALL SELECT 1 x FROM dual
   UNION ALL SELECT 2 x FROM dual
   UNION ALL SELECT 3 x FROM dual
   UNION ALL SELECT 4 x FROM dual
   UNION ALL SELECT 5 x FROM dual
   UNION ALL SELECT 6 x FROM dual
   UNION ALL SELECT 7 x FROM dual
   UNION ALL SELECT 8 x FROM dual
   UNION ALL SELECT 9 x FROM dual) jednosci,
  (SELECT 0 x FROM dual
   UNION ALL SELECT 10 x FROM dual
   UNION ALL SELECT 20 x FROM dual
   UNION ALL SELECT 30 x FROM dual
   UNION ALL SELECT 40 x FROM dual
   UNION ALL SELECT 50 x FROM dual
   UNION ALL SELECT 60 x FROM dual
   UNION ALL SELECT 70 x FROM dual
   UNION ALL SELECT 80 x FROM dual
   UNION ALL SELECT 90 x FROM dual) dziesiatki,
  (SELECT 0 x FROM dual
   UNION ALL SELECT 100 x FROM dual
   UNION ALL SELECT 200 x FROM dual
   UNION ALL SELECT 300 x FROM dual
   UNION ALL SELECT 400 x FROM dual
   UNION ALL SELECT 500 x FROM dual
   UNION ALL SELECT 600 x FROM dual
   UNION ALL SELECT 700 x FROM dual
   UNION ALL SELECT 800 x FROM dual
   UNION ALL SELECT 900 x FROM dual) setki;

COMMIT;
