Listing 10.1  
SELECT movie_title, director_id
FROM Movies


Listing 10.2  
CREATE VIEW Movie_Director
AS 
SELECT movie_title, director_id
FROM Movies


Listing 10.3  
SELECT *
FROM Movie_Director


Listing 10.4  
UPDATE Movies
SET movie_title = 'Vegetable House'
WHERE movie_title = 'Mineral House'


Listing 10.5 
CREATE VIEW Movie_With_Studio
AS
SELECT movie_title, budget, gross, studio_name, 
studio_city, studio_state
FROM Movies, Studios
WHERE Movies.studio_id = Studios.studio_id

SELECT movie_title, studio_name
FROM Movie_With_Studio


Listing 10.6  
CREATE VIEW Movies_Minus_Financials
AS
SELECT movie_id, movie_title, studio_id, release_date, director_id
FROM Movies

SELECT * 
FROM Movies_Minus_Financials


Listing 10.7  
CREATE VIEW Movie_Financials (title, budget, gross)
AS
SELECT movie_title, budget, gross
FROM Movies

SELECT * 
FROM Movie_Financials


Listing 10.8 
CREATE VIEW Texas_Phone_List
AS
SELECT person_fname, person_lname, person_phone
FROM People
WHERE person_state = 'TX'

SELECT *
FROM Texas_Phone_List


Listing 10.9 
CREATE VIEW Movie_Financials (movie_title, gross_ext, budget_ext) 
AS
SELECT movie_title, gross * 1000000, budget * 1000000
FROM Movies


Listing 10.10  
CREATE VIEW Movie_Financials  (title, actual_gross, actual_budget)
AS
SELECT movie_title, gross * 1000000, budget * 1000000
FROM Movies

SELECT title, actual_gross, actual_budget 
FROM Movie_Financials


Listing 10.11  
SELECT actual_gross
FROM Movie_Financials
WHERE title = 'The Code Warrior'


Listing 10.12  
CREATE VIEW Movies_Upper (title)
AS
SELECT UPPER(movie_title)
FROM Movies 

SELECT title
FROM Movies_Upper


Listing 10.13  
CREATE VIEW Total_Movie_Revenue (total_revenue)AS
SELECT SUM(gross)
FROM Movies

SELECT * 
FROM Total_Movie_Revenue


Listing 10.14.  
CREATE VIEW Budget_By_Studio (studio, total_budget, avg_budget)
AS
SELECT studio_id, SUM(budget), AVG(budget)
FROM Movies
GROUP BY studio_id

SELECT * FROM Budget_By_Studio


Listing 10.15  
SELECT studio_id, AVG(budget) AS avg_budget
FROM Movies
GROUP BY studio_id
HAVING AVG(budget) > 50


Listing 10.16  
SELECT studio, avg_budget
FROM Budget_By_Studio
WHERE avg_budget > 50


Listing 10.17  
SELECT SUM(avg_budget)
FROM Budget_By_Studio


Listing 10.18  
CREATE VIEW People_In_Studio_State
AS 
SELECT person_fname, person_lname, studio_name, person_state,
FROM People, Studios
WHERE person_state = studio_state


SELECT *
FROM People_In_Studio_State



Listing 10.19  
CREATE VIEW Local_Actors (movie, person, state)
AS
SELECT Loc.movie_id, P.person_id, Loc.state
FROM Locations Loc, People P, Cast_Movies CM
WHERE Loc.state = P.person_state
AND Loc.movie_id = CM.movie_id
AND P.person_id = CM.person_id


SELECT *
FROM Local_Actors


Listing 10.20  
CREATE VIEW Movies_From_Big_Budget_Studios
AS
SELECT movie_title, budget, gross
FROM Movies
WHERE studio_id IN
	(SELECT studio_id 
	FROM Movies
	GROUP BY studio_id
	HAVING AVG(budget) > 50)

SELECT *
FROM Movies_From_Big_Budget_Studios



Listing 10.21  
CREATE VIEW Cities_And_States (city, state)
AS 
SELECT studio_city, studio_state
FROM Studios
UNION
SELECT person_city, person_state
FROM People
UNION
SELECT city, state
FROM Locations

SELECT *
FROM Cities_And_States



Listing 10.22  
CREATE VIEW Movie_Cast (id, title, budget, role, payment)
AS 
SELECT Movies.movie_id, Movie_Financials.title, 
Movie_Financials.actual_budget, Cast_Movies.role, Cast_Movies.payment
FROM Movies, Movie_Financials, Cast_Movies
WHERE Movies.movie_id = Cast_Movies.movie_id
AND Movies.movie_title = Movie_Financials.title

SELECT title, budget, role, payment
FROM Movie_Cast


Listing 10.23.  
CREATE VIEW Basic_Movies
AS
SELECT movie_id, movie_title, studio_id, director_id, release_date
FROM Movies


Listing 10.24.  
INSERT INTO Basic_Movies
VALUES
(11, 'Star Wares', 1, 5, '01-JAN-1999')


Listing 10.25.  
SELECT movie_id, movie_title, gross, budget
FROM Movies
WHERE movie_id = 11


Listing 10.26.  
UPDATE Basic_Movies
SET gross = 50
WHERE movie_id = 11


Listing 10.27.  
UPDATE Basic_Movies
SET movie_title = 'Stare Wars'
WHERE movie_id = 11

SELECT *
FROM Basic_Movies
WHERE movie_id = 11


Listing 10.28  
DELETE FROM Basic_Movies
WHERE movie_id = 11


SELECT * 
FROM Basic_Movies
WHERE movie_id = 11


SELECT movie_id, movie_title
FROM Movies
WHERE movie_id = 11



Listing 10.29
CREATE TABLE Articles
(id 		INT PRIMARY KEY,
headline	VARCHAR2(255),
byline	VARCHAR2(80),
body		TEXT,
pub_date	DATE)


Listing 10.30
CREATE TABLE Keywords
(id		INT PRIMARY KEY,
category	VARCHAR2(12),
descript	VARCHAR2(40))


Listing 10.31 
CREATE TABLE Article_Keywords
(article_id		INT,
keyword_id		INT)

Table created.

Listing 10.32 
CREATE TABLE User_Keywords
(user_id		INT,
keyword_id		INT)

Table created.



Listing 10.33
CREATE VIEW Interest_Weight (user_id, article_id, weight)
AS
SELECT user_id, article_id, COUNT(Article_Keywords.keyword_id)
FROM User_Keywords, Article_Keywords
WHERE Article_Keywords.keyword_id = User_Keywords.keyword_id
AND Article_Keywords.keyword_id IN 
	(SELECT id 
	FROM Keywords 
	WHERE category = 'interest')
	GROUP BY user_id, article_id

SELECT * 
FROM Interest_Weight

Listing 10.34
CREATE VIEW Non_Interest_Weight (user_id, article_id, weight)
AS
SELECT user_id, article_id, COUNT(Article_Keywords.keyword_id)
FROM User_Keywords, Article_Keywords
WHERE Article_Keywords.keyword_id = User_Keywords.keyword_id
AND Article_Keywords.keyword_id IN 
	(SELECT id 
         FROM Keywords 
         WHERE category = 'non-interest')
         GROUP BY user_id, article_id


SELECT * 
FROM Non_Interest_Weight


Listing 10.36
CREATE VIEW Article_Weight (article_id, user_id, weight)
AS
SELECT IW.article_id, IW.user_id, 
(IW.weight * 2) + NIW.weight + TW.weight
FROM Time_Weight TW, Interest_Weight IW, Non_Interest_Weight NIW
WHERE IW.user_id = NIW.user_id
AND IW.article_id = NIW.article_id
AND IW.article_id = TW.article_id

Listing 10.35
CREATE VIEW Time_Weight (article_id, weight)
AS
SELECT id, 5
FROM Articles
WHERE pub_date BETWEEN (SYSDATE - 2) AND SYSDATE
UNION
SELECT id, 3
FROM Articles
WHERE pub_date BETWEEN (SYSDATE - 7) AND (SYSDATE - 2)
UNION
SELECT id, 0
FROM Articles
WHERE pub_date < (SYSDATE - 7)


SELECT * 
FROM Time_Weight



Listing 10.37
SELECT weight, id, headline
FROM Article_Weight, Articles
WHERE id = article_id
AND user_id = 1
ORDER BY weight DESC


Listing 10.38
CREATE VIEW Executive_Studio_Breakdown
(name, avg_budget, avg_gross, avg_profit,
total_budget, total_gross, total_profit)
AS
SELECT Studios.studio_name, AVG(budget), AVG(gross), AVG(gross - budget),
SUM(budget), SUM(gross), SUM(gross - budget)
FROM Studios, Movies
WHERE Studios.studio_id = Movies.studio_id
GROUP BY Studios.studio_name


Listing 10.39
CREATE VIEW Movie_Cast_Cost
(movie_id, budget, total_cast_payment, avg_cast_payment, num_cast)
AS
SELECT Cast_Movies.movie_id, 
Movies.budget,
SUM(Cast_Movies.payment),
AVG(Cast_Movies.payment),
COUNT(Cast_Movies.payment)
FROM Cast_Movies, Movies
WHERE Cast_Movies.movie_id = Movies.movie_id
GROUP BY Cast_Movies.movie_id, Movies.budget


Listing 10.40
CREATE VIEW Movie_Cast_Info
AS
SELECT Movies.movie_title, People.person_fname,
People.person_lname, Cast_Movies.role, Cast_Movies.payment
FROM Movies, People, Cast_Movies
WHERE Movies.movie_id = Cast_Movies.movie_id
AND People.person_id = Cast_Movies.movie_id
