-- Przykład 1
SELECT * FROM farmers_market.product_category;

SELECT * FROM farmers_market.product
WHERE product_category_id IN (1, 5, 6)
ORDER BY product_category_id;

SELECT *
FROM customer_purchases cp
    INNER JOIN product p
        ON cp.product_id = p.product_id
WHERE p.product_category_id = 1;

SELECT
    cp.market_date,
    cp.customer_id,
    cp.quantity,
    cp.cost_to_customer_per_qty,
    p.product_category_id,
    mdi.market_date,
    mdi.market_week,
    mdi.market_year,
    mdi.market_rain_flag,
    mdi.market_snow_flag
FROM customer_purchases cp
    INNER JOIN product p
        ON cp.product_id = p.product_id
    RIGHT JOIN market_date_info mdi
        ON mdi.market_date = cp.market_date
WHERE p.product_category_id = 1;

SELECT
    mdi.market_date,
    mdi.market_week,
    mdi.market_year,
    mdi.market_rain_flag,
    mdi.market_snow_flag,
    cp.market_date,
    cp.customer_id,
    cp.quantity,
    cp.cost_to_customer_per_qty,
    p.product_category_id
FROM customer_purchases cp
    INNER JOIN product p
        ON cp.product_id = p.product_id
            AND p.product_category_id = 1
    RIGHT JOIN market_date_info mdi
        ON mdi.market_date = cp.market_date;
        
SELECT
    mdi.market_year,
    mdi.market_week,
    MAX(mdi.market_rain_flag) AS market_week_rain_flag,
    MAX(mdi.market_snow_flag) AS market_week_snow_flag,
    MIN(mdi.market_min_temp) AS minimum_temperature,
    MAX(mdi.market_max_temp) AS maximum_temperature,
    MIN(mdi.market_season) AS market_season,
    ROUND(COALESCE(SUM(cp.quantity * cp.cost_to_customer_per_qty), 0), 2) AS weekly_category1_sales
FROM customer_purchases cp 
    INNER JOIN product p
        ON cp.product_id = p.product_id
            AND p.product_category_id = 1
    RIGHT JOIN market_date_info mdi
        ON mdi.market_date = cp.market_date
GROUP BY
    mdi.market_year,
    mdi.market_week;
    
    SELECT
    mdi.market_date,
    mdi.market_year,
    mdi.market_week,
    vi.*,
    p.*
FROM vendor_inventory vi
    INNER JOIN product p
        ON vi.product_id = p.product_id
            AND p.product_category_id = 1
    RIGHT JOIN market_date_info mdi
        ON mdi.market_date = vi.market_date;
        
SELECT
    mdi.market_year,
    mdi.market_week,
    COUNT(DISTINCT vi.vendor_id) AS vendor_count,
    COUNT(DISTINCT vi.product_id) AS unique_product_count,
    SUM(CASE WHEN p.product_qty_type = 'unit' THEN vi.quantity ELSE 0 END) AS unit_products_qty,
    SUM(CASE WHEN p.product_qty_type = 'lbs' THEN vi.quantity ELSE 0 END) AS bulk_products_lbs,
    ROUND(COALESCE(SUM(vi.quantity * vi.original_price), 0), 2) AS total_product_value,
    MAX(CASE WHEN p.product_id = 16 THEN 1 ELSE 0 END) AS corn_available_flag
FROM vendor_inventory vi 
   INNER JOIN product p
       ON vi.product_id = p.product_id
   RIGHT JOIN market_date_info mdi
       ON mdi.market_date = vi.market_date
GROUP BY
   mdi.market_year,
   mdi.market_week;
   
   SELECT
    mdi.market_year,
    mdi.market_week,
    COUNT(DISTINCT vi.vendor_id) AS vendor_count,
    COUNT(DISTINCT CASE WHEN p.product_category_id = 1 THEN vi.vendor_id 
ELSE NULL END) AS vendor_count_product_category1,
    COUNT(DISTINCT vi.product_id) AS unique_product_count,
    COUNT(DISTINCT CASE WHEN p.product_category_id = 1 THEN vi.product_id 
ELSE NULL END) AS unique_product_count_product_category1,
    SUM(CASE WHEN p.product_qty_type = 'unit' THEN vi.quantity ELSE 0 END) AS unit_products_qty,
    SUM(CASE WHEN p.product_category_id = 1 AND p.product_qty_type = 'unit' 
THEN vi.quantity ELSE 0 END) AS unit_products_qty_product_category1,
    SUM(CASE WHEN p.product_qty_type = 'lbs' THEN vi.quantity ELSE 0 END) AS bulk_products_lbs,
    SUM(CASE WHEN p.product_category_id = 1 AND p.product_qty_type = 'lbs' 
THEN vi.quantity ELSE 0 END) AS bulk_products_lbs_product_category1,
    ROUND(COALESCE(SUM(vi.quantity * vi.original_price), 0), 2) AS total_product_value,
    ROUND(COALESCE(SUM(CASE WHEN p.product_category_id = 1 THEN vi.quantity * vi.original_price ELSE 0 END), 0), 2) AS total_product_value_product_category1,
    MAX(CASE WHEN p.product_id = 16 THEN 1 ELSE 0 END) AS corn_available_flag 
FROM vendor_inventory vi
    INNER JOIN product p 
        ON vi.product_id = p.product_id
    RIGHT JOIN market_date_info mdi 
        ON mdi.market_date = vi.market_date
GROUP BY 
    mdi.market_year,
    mdi.market_week;
    
WITH
my_customer_purchases AS
(
       SELECT
            mdi.market_year,
            mdi.market_week,
            MAX(mdi.market_rain_flag) AS market_week_rain_flag,
            MAX(mdi.market_snow_flag) AS market_week_snow_flag,
            MIN(mdi.market_min_temp) AS minimum_temperature,
            MAX(mdi.market_max_temp) AS maximum_temperature,
            MIN(mdi.market_season) AS market_season,
            ROUND(COALESCE(SUM(cp.quantity * cp.cost_to_customer_per_qty), 0), 2) AS weekly_category1_sales
FROM customer_purchases cp 
              INNER JOIN product p
                      ON cp.product_id = p.product_id
                          AND p.product_category_id = 1
                  RIGHT JOIN market_date_info mdi
                      ON mdi.market_date = cp.market_date
      GROUP BY
          mdi.market_year,
          mdi.market_week
),
my_vendor_inventory AS
(
    SELECT
        mdi.market_year,
        mdi.market_week,
        COUNT(DISTINCT vi.vendor_id) AS vendor_count,
        COUNT(DISTINCT CASE WHEN p.product_category_id = 1 THEN vi.vendor_id ELSE NULL END) AS vendor_count_product_category1,
        COUNT(DISTINCT vi.product_id) unique_product_count,
        COUNT(DISTINCT CASE WHEN p.product_category_id = 1 THEN vi.product_id ELSE NULL END) AS unique_product_count_product_category1,
        SUM(CASE WHEN p.product_qty_type = 'unit' THEN vi.quantity ELSE 0 END) AS unit_products_qty,
        SUM(CASE WHEN p.product_category_id = 1 AND p.product_qty_type = 'unit' THEN vi.quantity ELSE 0 END) AS unit_products_qty_product_category1,
        SUM(CASE WHEN p.product_qty_type <> 'unit' THEN vi.quantity ELSE 0 END) AS bulk_products_qty,
        SUM(CASE WHEN p.product_category_id = 1 AND p.product_qty_type <> 'unit' THEN vi.quantity ELSE 0 END) AS bulk_products_qty_product_category1,
        ROUND(COALESCE(SUM(vi.quantity * vi.original_price), 0), 2) AS total_product_value,
        ROUND(COALESCE(SUM(CASE WHEN p.product_category_id = 1 THEN vi.quantity * vi.original_price ELSE 0 END), 0), 2) AS total_product_value_product_category1,
        MAX(CASE WHEN p.product_id = 16 THEN 1 ELSE 0 END) AS corn_available_flag 
    FROM vendor_inventory vi
        INNER JOIN product p
            ON vi.product_id = p.product_id
        RIGHT JOIN market_date_info mdi
            ON mdi.market_date = vi.market_date
    GROUP BY
        mdi.market_year,
        mdi.market_week
) 

SELECT *
FROM my_vendor_inventory
LEFT JOIN my_customer_purchases
    ON my_vendor_inventory.market_year = my_customer_purchases.market_year 
          AND my_vendor_inventory.market_week = my_customer_purchases.market_week
ORDER BY my_vendor_inventory.market_year, my_vendor_inventory.market_week;


WITH
my_customer_purchases AS
(
       SELECT
            mdi.market_year,
            mdi.market_week,
            MAX(mdi.market_rain_flag) AS market_week_rain_flag,
            MAX(mdi.market_snow_flag) AS market_week_snow_flag,
            MIN(mdi.market_min_temp) AS minimum_temperature,
            MAX(mdi.market_max_temp) AS maximum_temperature,
            MIN(mdi.market_season) AS market_season,
            ROUND(COALESCE(SUM(cp.quantity * cp.cost_to_customer_per_qty), 0), 2) AS weekly_category1_sales
FROM customer_purchases cp 
              INNER JOIN product p
                      ON cp.product_id = p.product_id
                          AND p.product_category_id = 1
                  RIGHT JOIN market_date_info mdi
                      ON mdi.market_date = cp.market_date
      GROUP BY
          mdi.market_year,
          mdi.market_week
),
my_vendor_inventory AS
(
    SELECT
        mdi.market_year,
        mdi.market_week,
        COUNT(DISTINCT vi.vendor_id) AS vendor_count,
        COUNT(DISTINCT CASE WHEN p.product_category_id = 1 THEN vi.vendor_id ELSE NULL END) AS vendor_count_product_category1,
        COUNT(DISTINCT vi.product_id) unique_product_count,
        COUNT(DISTINCT CASE WHEN p.product_category_id = 1 THEN vi.product_id ELSE NULL END) AS unique_product_count_product_category1,
        SUM(CASE WHEN p.product_qty_type = 'unit' THEN vi.quantity ELSE 0 END) AS unit_products_qty,
        SUM(CASE WHEN p.product_category_id = 1 AND p.product_qty_type = 'unit' THEN vi.quantity ELSE 0 END) AS unit_products_qty_product_category1,
        SUM(CASE WHEN p.product_qty_type <> 'unit' THEN vi.quantity ELSE 0 END) AS bulk_products_qty,
        SUM(CASE WHEN p.product_category_id = 1 AND p.product_qty_type <> 'unit' THEN vi.quantity ELSE 0 END) AS bulk_products_qty_product_category1,
        ROUND(COALESCE(SUM(vi.quantity * vi.original_price), 0), 2) AS total_product_value,
        ROUND(COALESCE(SUM(CASE WHEN p.product_category_id = 1 THEN vi.quantity * vi.original_price ELSE 0 END), 0), 2) AS total_product_value_product_category1,
        MAX(CASE WHEN p.product_id = 16 THEN 1 ELSE 0 END) AS corn_available_flag 
    FROM vendor_inventory vi
        INNER JOIN product p
            ON vi.product_id = p.product_id
        RIGHT JOIN market_date_info mdi
            ON mdi.market_date = vi.market_date
    GROUP BY
        mdi.market_year,
        mdi.market_week
) 

SELECT
    mvi.market_year,
    mvi.market_week,
    mcp.market_week_rain_flag,
    mcp.market_week_snow_flag,
    mcp.minimum_temperature,
    mcp.maximum_temperature,
    mcp.market_season,
    mvi.vendor_count,
    mvi.vendor_count_product_category1,
    mvi.unique_product_count,
    mvi.unique_product_count_product_category1,
    mvi.unit_products_qty,
    mvi.unit_products_qty_product_category1,
    mvi.bulk_products_qty,
    mvi.bulk_products_qty_product_category1,
    mvi.total_product_value,
    mvi.total_product_value_product_category1,
    LAG(mcp.weekly_category1_sales, 1) OVER (ORDER BY mvi.market_year,
mvi.market_week) AS previous_week_category1_sales,
    mcp.weekly_category1_sales
FROM my_vendor_inventory mvi
    LEFT JOIN my_customer_purchases mcp
        ON mvi.market_year = mcp.market_year
            AND mvi.market_week = mcp.market_week
ORDER BY mvi.market_year, mvi.market_week;

-- Przykład 2

SELECT
    c.customer_id,
    c.customer_zip,
    DATEDIFF(MAX(market_date), MIN(market_date)) customer_duration_days,
    COUNT(DISTINCT market_date) number_of_markets,
    ROUND(SUM(quantity * cost_to_customer_per_qty), 2) total_spent,
    ROUND(SUM(quantity * cost_to_customer_per_qty) / COUNT(DISTINCT market_date), 2) average_spent_per_market
FROM farmers_market.customer c
LEFT JOIN farmers_market.customer_purchases cp
    ON cp.customer_id = c.customer_id
GROUP BY c.customer_id;

SELECT * FROM zip_data;

SELECT
    c.customer_id,
    DATEDIFF(MAX(market_date),
    MIN(market_date)) AS customer_duration_days,
    COUNT(DISTINCT market_date) AS number_of_markets,
    ROUND(SUM(quantity * cost_to_customer_per_qty), 2) AS total_spent,
    ROUND(SUM(quantity * cost_to_customer_per_qty) / COUNT(DISTINCT market_date), 2) AS average_spent_per_market,
    c.customer_zip, 
    z.median_household_income AS zip_median_household_income,
    z.percent_high_income AS zip_percent_high_income,
    z.percent_under_18 AS zip_percent_under_18,
    z.percent_over_65 AS zip_percent_over_65,
    z.people_per_sq_mile AS zip_people_per_sq_mile,
    z.latitude,
    z.longitude
FROM farmers_market.customer c
    LEFT JOIN farmers_market.customer_purchases cp
        ON cp.customer_id = c.customer_id
    LEFT JOIN zip_data z
        ON c.customer_zip = z.zip_code_5
GROUP BY c.customer_id;

SELECT
    c.customer_id,
    DATEDIFF(MAX(market_date),
    MIN(market_date)) AS customer_duration_days,
    COUNT(DISTINCT market_date) AS number_of_markets,
    ROUND(SUM(quantity * cost_to_customer_per_qty), 2) AS total_spent,
    ROUND(SUM(quantity * cost_to_customer_per_qty) / COUNT(DISTINCT market_date), 2) AS average_spent_per_market,
    c.customer_zip, 
    z.median_household_income AS zip_median_household_income,
    z.percent_high_income AS zip_percent_high_income,
    z.percent_under_18 AS zip_percent_under_18,
    z.percent_over_65 AS zip_percent_over_65,
    z.people_per_sq_mile AS zip_people_per_sq_mile,
    ROUND(2 * 3961 * ASIN(SQRT(POWER(SIN(RADIANS((z.latitude - 38.4463) / 2)),2) + COS(RADIANS(38.4463)) * COS(RADIANS(z.latitude)) * POWER((SIN(RADIANS((z.longitude - - 78.8712) / 2))), 2)))) AS zip_miles_from_market
FROM farmers_market.customer AS c 
    LEFT JOIN farmers_market.customer_purchases AS cp
        ON cp.customer_id = c.customer_id
    LEFT JOIN zip_data AS z
        ON c.customer_zip = z.zip_code_5
GROUP BY c.customer_id;

WITH customer_and_zip_data AS
(
    SELECT
        c.customer_id,
        DATEDIFF(MAX(market_date),
        MIN(market_date)) AS customer_duration_days,
        COUNT(DISTINCT market_date) AS number_of_markets,
        ROUND(SUM(quantity * cost_to_customer_per_qty), 2) AS total_spent,
        ROUND(SUM(quantity * cost_to_customer_per_qty) / COUNT(DISTINCT market_date), 2) AS average_spent_per_market, c.customer_zip, 
       z.median_household_income AS zip_median_household_income,
       z.percent_high_income AS zip_percent_high_income,
       z.percent_under_18 AS zip_percent_under_18,
       z.percent_over_65 AS zip_percent_over_65,
       z.people_per_sq_mile AS zip_people_per_sq_mile,
       ROUND(2 * 3961 * ASIN(SQRT(POWER(SIN(RADIANS((z.latitude - 38.4463) / 2)),2) + COS(RADIANS(38.4463)) * COS(RADIANS(z.latitude)) * POWER((SIN(RADIANS((z.longitude - - 78.8712) / 2))), 2)))) AS zip_miles_from_market 
    FROM farmers_market.customer AS c
        LEFT JOIN farmers_market.customer_purchases AS cp
            ON cp.customer_id = c.customer_id
        LEFT JOIN zip_data AS z
            ON c.customer_zip = z.zip_code_5
    GROUP BY c.customer_id
)

SELECT
    cz.customer_zip,
    COUNT(cz.customer_id) AS customer_count,
    ROUND(AVG(cz.total_spent)) AS average_total_spent,
    MIN(cz.zip_miles_from_market) AS zip_miles_from_market
FROM customer_and_zip_data AS cz
GROUP BY cz.customer_zip;

-- Przykład 3

SELECT
    p.product_id,
    p.product_name,
    p.product_category_id,
    p.product_qty_type,
    vi.vendor_id,
    vi.market_date,
    SUM(vi.quantity),
    AVG(vi.original_price)
FROM product AS p
    LEFT JOIN vendor_inventory AS vi
        ON vi.product_id = p.product_id
GROUP BY
    p.product_id,
    p.product_name,
    p.product_category_id,
    p.product_qty_type,
    vi.vendor_id,
    vi.market_date;
    
SELECT
    p.product_id,
    p.product_name,
    p.product_category_id,
    p.product_qty_type,
    vi.vendor_id,
    MIN(MONTH(vi.market_date)) AS month_market_season_sort,
    mdi.market_season,
    mdi.market_year,
    SUM(vi.quantity) AS quantity_available,
    AVG(vi.original_price) AS avg_original_price
FROM product AS p
    LEFT JOIN vendor_inventory AS vi
        ON vi.product_id = p.product_id
    LEFT JOIN market_date_info AS mdi
        ON vi.market_date = mdi.market_date
GROUP BY
    p.product_id,
    p.product_name,
    p.product_category_id,
    p.product_qty_type,
    vi.vendor_id,
    mdi.market_year,
    mdi.market_season;

SELECT
    p.product_id,
    p.product_name,
    p.product_category_id,
    p.product_qty_type,
    vi.vendor_id,
    MIN(MONTH(vi.market_date)) OVER (PARTITION BY market_season) AS month_market_season_sort,
    mdi.market_season,
    mdi.market_year,
    AVG(vi.original_price) AS avg_original_price,
    SUM(cp.quantity) AS quantity_sold,
    SUM(cp.quantity * cp.cost_to_customer_per_qty) AS total_sales
FROM product AS p
    LEFT JOIN vendor_inventory AS vi
        ON vi.product_id = p.product_id
    LEFT JOIN market_date_info AS mdi
        ON vi.market_date = mdi.market_date
    LEFT JOIN customer_purchases AS cp
        ON vi.product_id = cp.product_id
        AND vi.vendor_id = cp.vendor_id
        AND vi.market_date = cp.market_date
GROUP BY
    p.product_id,
    p.product_name,
    p.product_category_id,
    p.product_qty_type,
    vi.vendor_id,
    mdi.market_year,
    mdi.market_season;
    
    SELECT
    mdi.market_season,
    mdi.market_year,
    MIN(MONTH(vi.market_date)) OVER (PARTITION BY market_season) AS month_market_season_sort,
    vi.original_price,
    NTILE(3) OVER (PARTITION BY market_year, market_season ORDER BY original_price) AS price_ntile,
    NTILE(3) OVER (PARTITION BY market_year, market_season ORDER BY original_price DESC) AS price_ntile_desc,
    COUNT(DISTINCT CONCAT(vi.product_id, vi.vendor_id)) product_count,
    SUM(cp.quantity) AS quantity_sold,
    SUM(cp.quantity * cp.cost_to_customer_per_qty) AS total_sales 
FROM product AS p
    LEFT JOIN vendor_inventory AS vi
        ON vi.product_id = p.product_id
    LEFT JOIN market_date_info AS mdi
        ON vi.market_date = mdi.market_date
    LEFT JOIN customer_purchases AS cp
        ON vi.product_id = cp.product_id
        AND vi.vendor_id = cp.vendor_id
        AND vi.market_date = cp.market_date
WHERE market_year IS NOT NULL
GROUP BY
    mdi.market_year,
    mdi.market_season,
    vi.original_price;

WITH product_prices AS
(
    SELECT
        mdi.market_season,
        mdi.market_year,
        MIN(MONTH(vi.market_date)) OVER (PARTITION BY market_season) AS month_market_season_sort,
        vi.original_price,
        NTILE(3) OVER (PARTITION BY market_year, market_season ORDER BY original_price) AS price_ntile,
        NTILE(3) OVER (PARTITION BY market_year, market_season ORDER BY original_price DESC) AS price_ntile_desc,
        COUNT(DISTINCT CONCAT(vi.product_id, vi.vendor_id)) AS product_count,
        SUM(cp.quantity) AS quantity_sold,
        SUM(cp.quantity * cp.cost_to_customer_per_qty) AS total_sales 
    FROM product AS p
        LEFT JOIN vendor_inventory AS vi
            ON vi.product_id = p.product_id
        LEFT JOIN market_date_info AS mdi
            ON vi.market_date = mdi.market_date
            LEFT JOIN customer_purchases AS cp
                ON vi.product_id = cp.product_id
                AND vi.vendor_id = cp.vendor_id
                AND vi.market_date = cp.market_date
WHERE market_year IS NOT NULL
GROUP BY
    mdi.market_year,
    mdi.market_season,
    vi.original_price
)

SELECT
    market_year,
    market_season,
    price_ntile,
    SUM(product_count) AS product_count,
    SUM(quantity_sold) AS quantity_sold,
    MIN(original_price) AS min_price,
    MAX(original_price) AS max_price,
    SUM(total_sales) AS total_sales
FROM product_prices
GROUP BY
    market_year,
    market_season,
    price_ntile
ORDER BY
    market_year,
    month_market_season_sort,
    price_ntile;

