-- Rozdział 2.
SELECT * FROM farmers_market.customer;

SELECT *
FROM farmers_market.customer
ORDER BY customer_last_name, customer_first_name
LIMIT 10;

SELECT
    customer_id,
    customer_first_name
FROM farmers_market.customer
ORDER BY customer_first_name;

-- Rozdział 3.

SELECT *
FROM farmers_market.customer_purchases
WHERE product_id = 4
    OR product_id = 9;
    
SELECT *
FROM farmers_market.customer_purchases
WHERE vendor_id >= 8
    AND vendor_id <= 10;

SELECT *
FROM farmers_market.customer_purchases
WHERE vendor_id BETWEEN 8 AND 10;

    
SELECT
    market_date,
    customer_id,
    vendor_id,
    quantity * cost_to_customer_per_qty AS price
FROM farmers_market.customer_purchases
WHERE
    market_date NOT IN
        (
        SELECT market_date
        FROM farmers_market.market_date_info
        WHERE market_rain_flag = 1
        );


SELECT
    market_date,
    customer_id,
    vendor_id,
    quantity * cost_to_customer_per_qty AS price
FROM farmers_market.customer_purchases
WHERE
    market_date IN
        (
        SELECT market_date
        FROM farmers_market.market_date_info
        WHERE market_rain_flag = 0
        );

-- Rozdział 4. 

SELECT
    product_id,
    product_name,
    CASE WHEN product_qty_type = "Unit"
        THEN "na sztuki" 
        ELSE "luzem"
    END AS prod_qty_type_condensed
FROM farmers_market.product;

SELECT
    product_id,
    product_name,
    CASE WHEN product_qty_type = "Unit"
        THEN "na sztuki"
        ELSE "luzem"
    END AS prod_qty_type_condensed,
    CASE WHEN LOWER(product_name) LIKE '%pepper%'
        THEN 1 
        ELSE 0
    END AS pepper_flag
FROM farmers_market.product;

-- Rozdział 5.

SELECT *
FROM vendor AS v
    INNER JOIN vendor_booth_assignments AS vba
        ON v.vendor_id = vba.vendor_id
ORDER BY v.vendor_name, vba.market_date;

SELECT c.*, cp.*
     FROM customer_purchases AS cp
         LEFT JOIN customer AS c
             ON cp.customer_id = c.customer_id;

-- Rozdział 6.

SELECT
    vendor_id,
    count(*) AS count_of_booth_assignments
FROM farmers_market.vendor_booth_assignments
GROUP BY vendor_id;

SELECT
    pc.product_category_name,
    p.product_name,
    min(market_date) AS first_date_available,
    max(market_date) AS last_date_available
FROM farmers_market.vendor_inventory vi
    INNER JOIN farmers_market.product p
        ON vi.product_id = p.product_id
    INNER JOIN farmers_market.product_category pc
        ON p.product_category_id = pc.product_category_id
WHERE product_category_name = 'Fresh Fruits & Vegetables'
GROUP BY p.product_name;

SELECT
    cp.customer_id,
    c.customer_first_name,
    c.customer_last_name,
    SUM(quantity * cost_to_customer_per_qty) AS total_spent
FROM farmers_market.customer c
    LEFT JOIN farmers_market.customer_purchases cp
        ON c.customer_id = cp.customer_id
GROUP BY
    cp.customer_id,
    c.customer_first_name,
    c.customer_last_name
HAVING total_spent > 50
ORDER BY c.customer_last_name, c.customer_first_name;

-- Rozdział 7. 

 SELECT cp.*,
    DENSE_RANK() OVER (PARTITION BY customer_id ORDER BY market_date)
AS visit_number
FROM farmers_market.customer_purchases AS cp
ORDER BY customer_id, market_date;

SELECT customer_id, market_date,
    ROW_NUMBER() OVER (PARTITION BY customer_id ORDER BY market_date)
AS visit_number
FROM farmers_market.customer_purchases
GROUP BY customer_id, market_date
ORDER BY customer_id, market_date;

SELECT * FROM
(
	SELECT customer_id, market_date,
		ROW_NUMBER() OVER (PARTITION BY customer_id ORDER BY market_date DESC) AS visit_number
	FROM farmers_market.customer_purchases GROUP BY customer_id, market_date ORDER BY customer_id, market_date
)x 
WHERE x.visit_number = 1;

SELECT * FROM
(
	SELECT cp.*,
            DENSE_RANK() OVER (PARTITION BY customer_id ORDER BY market_date DESC) AS visit_number
	FROM farmers_market.customer_purchases AS cp
	ORDER BY customer_id, market_date
) x
WHERE x.visit_number = 1;

SELECT cp.*,
    COUNT(product_id) OVER (PARTITION BY customer_id, product_id) AS
product_purchase_count
FROM farmers_market.customer_purchases AS cp
ORDER BY customer_id, product_id, market_date;

SELECT
    market_date,
    SUM(quantity * cost_to_customer_per_qty) AS market_date_total_sales, 
    LEAD(SUM(quantity * cost_to_customer_per_qty), 1) OVER (ORDER BY
market_date DESC) AS previous_market_date_total_sales
FROM farmers_market.customer_purchases
GROUP BY market_date
ORDER BY market_date;

-- Rozdział 8. 
SELECT
    customer_id,
    EXTRACT(MONTH FROM market_date) AS purchase_month,
    EXTRACT(YEAR FROM market_date) AS purchase_year
FROM farmers_market.customer_purchases;

SELECT MIN(market_date) AS sales_since_date,
    SUM(quantity * cost_to_customer_per_qty) AS total_sales
FROM farmers_market.customer_purchases
WHERE DATEDIFF('2019-03-31', market_date) <= 14;

SELECT MIN(market_date) AS sales_since_date,
    SUM(quantity * cost_to_customer_per_qty) AS total_sales
FROM farmers_market.customer_purchases
WHERE DATEDIFF(CURDATE(), market_date) <= 14;

SELECT
    market_date,
    market_day,
    DAYNAME(market_date) AS calculated_market_day,
    CASE WHEN market_day <> DAYNAME(market_date) then "Błędnie wprowadzone dane"
        ELSE "Poprawne" END AS entered_correctly
FROM farmers_market.market_date_info;

-- Rozdział 9. 

SELECT MIN(market_date), MAX(market_date)
FROM farmers_market.customer_purchases;

SELECT DAYNAME(market_date),
    EXTRACT(HOUR FROM transaction_time),
    COUNT(DISTINCT customer_id)
FROM farmers_market.customer_purchases
GROUP BY DAYNAME(market_date),  EXTRACT(HOUR FROM transaction_time)
ORDER BY DAYNAME(market_date),  EXTRACT(HOUR FROM transaction_time);

SELECT market_date, COUNT(DISTINCT customer_id)
FROM customer_purchases
GROUP BY market_date
ORDER BY market_date;


SELECT market_date, vendor_id,
    ROUND(SUM(quantity * original_price),2) AS inventory_value
FROM vendor_inventory
GROUP BY market_date, vendor_id
ORDER BY market_date, vendor_id;

-- Rozdział 10. 

SELECT market_week, vendor_id, vendor_name,
       SUM(sales) AS weekly_sales
FROM farmers_market.vw_sales_by_day_vendor AS s
GROUP BY market_week, vendor_id, vendor_name
ORDER BY market_date;

WITH x AS
(
SELECT
    market_date,
    vendor_id,
    booth_number,
    LAG(booth_number,1) OVER (PARTITION BY vendor_id ORDER BY market_date, vendor_id) AS previous_booth_number
FROM farmers_market.vendor_booth_assignments
ORDER BY market_date, vendor_id, booth_number
)

SELECT *
FROM x
WHERE
    x.market_date = '2020-03-13'
    AND
    (x.booth_number <> x.previous_booth_number
    OR x.previous_booth_number IS NULL);

SELECT
    cp.market_date,
    md.market_day,
    md.market_week,
    md.market_year,
    cp.vendor_id,
    v.vendor_name,
    v.vendor_type,
    vba.booth_number,
    b.booth_type,
    ROUND(SUM(cp.quantity * cp.cost_to_customer_per_qty),2) AS sales
FROM farmers_market.customer_purchases AS cp
    LEFT JOIN farmers_market.market_date_info AS md
        ON cp.market_date = md.market_date
    LEFT JOIN farmers_market.vendor AS v
        ON cp.vendor_id = v.vendor_id
    LEFT JOIN farmers_market.vendor_booth_assignments AS vba
        ON cp.vendor_id = vba.vendor_id
        AND cp.market_date = vba.market_date
    LEFT JOIN farmers_market.booth AS b
        ON vba.booth_number = b.booth_number
GROUP BY cp.market_date, cp.vendor_id
ORDER BY cp.market_date, cp.vendor_id;

-- Rozdział 11.
 WITH
 sales_per_market_date AS
 (
     SELECT
         market_date,
         ROUND(SUM(quantity * cost_to_customer_per_qty),2) AS sales
     FROM farmers_market.customer_purchases
     GROUP BY market_date
     ORDER BY market_date
 ),
 record_sales_per_market_date AS
 (
    SELECT
          cm.market_date,
          cm.sales,
          MAX(pm.sales) AS previous_max_sales,
          CASE WHEN cm.sales > MAX(pm.sales)
              THEN "YES"
              ELSE "NO"
          END sales_record_set
    FROM sales_per_market_date AS cm
		LEFT JOIN sales_per_market_date AS pm
            ON pm.market_date < cm.market_date
    GROUP BY cm.market_date, cm.sales
)

SELECT
    market_date,
    sales
FROM record_sales_per_market_date
WHERE sales_record_set = 'YES'
ORDER BY market_date DESC
LIMIT 1;

 WITH
customer_markets_vendors AS
(
    SELECT DISTINCT
        customer_id,
        vendor_id,
        market_date,
        MIN(market_date) OVER(PARTITION BY cp.customer_id,
cp.vendor_id) AS first_purchase_from_vendor_date
    FROM farmers_market.customer_purchases cp
)
SELECT
    md.market_year,
    md.market_week,
    cmv.vendor_id,
    COUNT(customer_id) AS customer_visit_count,
    COUNT(DISTINCT customer_id) AS distinct_customer_count,
    COUNT(DISTINCT
        CASE WHEN cmv.market_date = cmv.first_purchase_from_vendor_date
            THEN customer_id
              ELSE NULL
              END) AS new_customer_count,
       COUNT(DISTINCT
           CASE WHEN cmv.market_date = cmv.first_purchase_from_vendor_date
               THEN customer_id
               ELSE NULL
           END)
           / COUNT(DISTINCT customer_id)
           AS new_customer_percent
   FROM customer_markets_vendors AS cmv
       LEFT JOIN farmers_market.market_date_info AS md
           ON cmv.market_date = md.market_date
   GROUP BY md.market_year, md.market_week, cmv.vendor_id
   ORDER BY md.market_year, md.market_week, cmv.vendor_id;

WITH
sales_per_market AS
(
    SELECT
        market_date,
        ROUND(SUM(quantity * cost_to_customer_per_qty),2) AS sales
    FROM farmers_market.customer_purchases
    GROUP BY market_date
 ),
 market_dates_ranked_by_sales AS
 (
    SELECT
        market_date,
        sales,
        RANK() OVER (ORDER BY sales) AS sales_rank_asc,
        RANK() OVER (ORDER BY sales DESC) AS sales_rank_desc
    FROM sales_per_market
 )
SELECT market_date, sales, sales_rank_desc AS sales_rank
FROM market_dates_ranked_by_sales
WHERE sales_rank_asc = 1

UNION

SELECT market_date, sales, sales_rank_desc AS sales_rank
FROM market_dates_ranked_by_sales
WHERE sales_rank_desc = 1;

-- Rozdział 12.
-- (SELECT COUNT(market_date)
--     FROM customer_markets_attended cma
--     WHERE cma.customer_id = cp.customer_id
--         AND cma.market_date < cp.market_date
--         AND DATEDIFF(cp.market_date, cma.market_date) <= 14) AS
-- customer_markets_attended_14days_count,

-- MAX(CASE WHEN cp.cost_to_customer_per_qty > 10 THEN 1 ELSE 0 END)
-- purchased_item_over_10_dollars,

 WITH
customer_markets_attended AS
(
    SELECT
        customer_id,
        market_date,
        SUM(quantity * cost_to_customer_per_qty) AS purchase_total,
        ROW_NUMBER() OVER (PARTITION BY customer_id ORDER BY market_date) AS market_count
    FROM farmers_market.customer_purchases
    GROUP BY customer_id, market_date
    ORDER BY customer_id, market_date
)

SELECT
    cp.customer_id,
    cp.market_date,
    EXTRACT(MONTH FROM cp.market_date) AS market_month,
    SUM(cp.quantity * cp.cost_to_customer_per_qty) AS purchase_total,
    COUNT(DISTINCT cp.vendor_id) AS vendors_patronized,
    MAX(CASE WHEN cp.vendor_id = 7 THEN 1 ELSE 0 END) AS purchased_from_vendor_7,
    MAX(CASE WHEN cp.vendor_id = 8 THEN 1 ELSE 0 END) AS purchased_from_vendor_8,
    COUNT(DISTINCT cp.product_id) AS different_products_purchased,
    DATEDIFF(cp.market_date,
        (SELECT MAX(cma.market_date)
        FROM customer_markets_attended AS cma
        WHERE cma.customer_id = cp.customer_id
            AND cma.market_date < cp.market_date
        GROUP BY cma.customer_id)) days_since_last_customer_market_date,
    (SELECT MAX(market_count)
        FROM customer_markets_attended cma
        WHERE cma.customer_id = cp.customer_id
            AND cma.market_date <= cp.market_date) AS customer_markets_attended_count,
    (SELECT COUNT(market_date)
        FROM customer_markets_attended cma
        WHERE cma.customer_id = cp.customer_id
            AND cma.market_date < cp.market_date
            AND DATEDIFF(cp.market_date, cma.market_date) <= 30) AS customer_markets_attended_30days_count,
    (SELECT COUNT(market_date)
        FROM customer_markets_attended cma
        WHERE cma.customer_id = cp.customer_id
            AND cma.market_date < cp.market_date
            AND DATEDIFF(cp.market_date, cma.market_date) <= 14) AS customer_markets_attended_14days_count,
    MAX(CASE WHEN cp.cost_to_customer_per_qty > 10 THEN 1 ELSE 0 END) AS purchased_item_over_10_dollars,
    (SELECT SUM(purchase_total)
        FROM customer_markets_attended cma
        WHERE cma.customer_id = cp.customer_id
            AND cma.market_date <= cp.market_date) AS total_spent_to_date,
        CASE WHEN
    (SELECT SUM(purchase_total)
        FROM customer_markets_attended cma
        WHERE cma.customer_id = cp.customer_id
            AND cma.market_date <= cp.market_date) > 200
        THEN 1 ELSE 0 END AS customer_has_spent_over_200,
        CASE WHEN
        DATEDIFF(
            (SELECT MIN(cma.market_date)
            FROM customer_markets_attended AS cma
              WHERE cma.customer_id = cp.customer_id
                  AND cma.market_date > cp.market_date
                  GROUP BY cma.customer_id),
                        cp.market_date) <=30 THEN 1 ELSE 0 END AS purchased_again_within_30_days
FROM farmers_market.customer_purchases AS cp
GROUP BY cp.customer_id, cp.market_date
ORDER BY cp.customer_id, cp.market_date;

 
