-- Wczytaj bazę danych sqlda.

$ psql sqlda

-- Usuń istniejącą tabelę lemon_sales.

sqlda=# DROP TABLE lemon_sales;

-- Dla skutera Lemon z 2013 r. kolumna product_id ma wartość 3. Pobierz z tabeli sales kolumny customer_id i sales_transaction_date 
-- dotyczące tego modelu. Wstaw te informacje do tabeli lemon_sales.

sqlda=# SELECT customer_id, sales_transaction_date INTO lemon_sales FROM sales WHERE product_id=3;

-- Pobierz z tabeli emails wszystkie informacje o klientach, którzy zakupili model Lemon. Umieść te informacje w nowej tabeli, lemon_emails.

sqlda=# SELECT emails.customer_id, emails.email_subject, emails.opened, emails.sent_date, emails.opened_date, lemon_sales.sales_transaction_date INTO lemon_emails FROM emails INNER JOIN lemon_sales ON emails.customer_id=lemon_sales.customer_id;

-- Usuń wszystkie e-maile wysłane przed rozpoczęciem produkcji skutera Lemon. Potrzebna będzie do tego data początku produkcji.

sqlda=# SELECT production_start_date FROM products Where product_id=3;

-- Teraz usuń e-maile wysłane przed rozpoczęciem produkcji skutera Lemon.

sqlda=# DELETE FROM lemon_emails WHERE sent_date < '2013-05-01';

-- Usuń też wszystkie wiersze, w których data wysłania e-maila jest późniejsza niż data zakupu (sales_transaction_date).

sqlda=# DELETE FROM lemon_emails WHERE sent_date > sales_transaction_date;

-- Usuń wszystkie wiersze, w których data wysyłki jest wcześniejsza o ponad 30 dni od daty zakupu (sales_transaction_date).

sqlda=# DELETE FROM lemon_emails WHERE (sales_transaction_date - sent_date) > '30 days';

-- Usuń z tabeli lemon_emails wszystkie wiersze, w których temat e-maila nie jest związany ze skuterami Lemon. Wcześniej jednak poszukaj wszystkich unikatowych e-maili.

sqlda=# SELECT DISTINCT(email_subject) FROM lemon_emails;

-- Teraz usuń tematy niepowiązane ze skuterem Lemon. Użyj polecenia DELETE.

sqlda=# DELETE FROM lemon_emails WHERE POSITION('25% off all EVs.' in email_subject)>0;
sqlda=# DELETE FROM lemon_emails WHERE POSITION('Like a Bat out of Heaven' in email_subject)>0;
sqlda=# DELETE FROM lemon_emails WHERE POSITION('Save the Planet' in email_subject)>0;
sqlda=# DELETE FROM lemon_emails WHERE POSITION('An Electric Car' in email_subject)>0;
sqlda=# DELETE FROM lemon_emails WHERE POSITION('We cut you a deal' in email_subject)>0;
sqlda=# DELETE FROM lemon_emails WHERE POSITION('Black Friday. Green Cars.' in email_subject)>0;
sqlda=# DELETE FROM lemon_emails WHERE POSITION('Zoom' in email_subject)>0;

-- Teraz sprawdź, ile e-maili do klientów z tabeli lemon_scooter zostało otwartych.

sqlda=# SELECT COUNT(opened) FROM lemon_emails WHERE opened='t';

-- Wyświetl liczbę klientów, którzy otrzymali e-mail i dokonali zakupu

sqlda=# SELECT COUNT(DISTINCT(customer_id)) FROM lemon_emails;

-- Oblicz procent klientów, którzy otworzyli otrzymane e-maile i dokonali zakupu.

sqlda=# SELECT 128.0/506.0 AS email_rate;

-- Ustal liczbę unikatowych klientów, którzy kupili skuter.

sqlda=# SELECT COUNT(DISTINCT(customer_id)) FROM lemon_sales;

-- Oblicz procent klientów, którzy dokonali zakupu po otrzymaniu e-maila. To umożliwi Ci porównanie wyniku z wartościami dla skutera Bat.

sqlda=# SELECT 506.0/13854.0 AS email_sales;

-- Pobierz z tabeli lemon_emails wszystkie rekordy dotyczące transakcji z pierwszych trzech tygodni od rozpoczęcia produkcji. 
-- Zapisz wyniki w nowej tabeli, lemon_emails_threewks.

sqlda=# SELECT * INTO lemon_emails_threewks FROM lemon_emails WHERE sales_transaction_date < '2013-06-01';

-- Zlicz e-maile wysłane do nabywców skutera Lemon w pierwszych trzech tygodniach sprzedaży.

sqlda=# SELECT COUNT(sales_transaction_date) FROM lemon_emails_threewks;