-- Usuwanie wszystkich istniejących indeksów za pomocą polecenia DROP INDEX.

DROP INDEX <index name>; 

-- Użyj instrukcji EXPLAIN i ANALYZE do zbadania kwerendy dotyczącej tabeli customer bez indeksu z haszowaniem.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE gender='M';

-- Utwórz dla kolumny gender indeks w postaci B-drzewa i ponów kwerendę, aby ustalić wydajność, gdy używany jest indeks domyślny

sqlda=# CREATE INDEX ix_gender ON customers USING btree(gender);

-- Ręcznie uruchom poniższą kwerendę przynajmniej pięciokrotnie i zwróć uwagę na to, jak zmieniają się szacunki czasu.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE gender='M';

-- Usuń indeks.
 
sqlda=# DROP INDEX ix_gender;

-- Utwórz indeks z haszowaniem dla kolumny gender.

sqlda=# CREATE INDEX ix_gender ON customers USING HASH(gender);

-- Powtórz kwerendę z kroku 4., aby sprawdzić czas wykonania.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE gender='M';

-- Użyj polecenia EXPLAIN ANALYZE, aby ocenić wydajność kwerendy, która pobiera wszystkich klientów ze stanu FO.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE state='FO';

-- Utwórz indeks w postaci B-drzewa dla kolumny state z tabeli customers i ponownie sprawdź wydajność kwerendy.

sqlda=# CREATE INDEX ix_state ON customers USING BTREE(state);
sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE state='FO';

-- Usuń indeks w postaci B-drzewa ix_state i utwórz indeks z haszowaniem.

sqlda=# DROP INDEX ix_state;
sqlda=# CREATE INDEX ix_state ON customers USING HASH(state);

-- Użyj polecenia EXPLAIN ANALYZE, aby ocenić wydajność skanowania z haszowaniem.

sqlda=# EXPLAIN ANALYZE SELECT * FROM customers WHERE state='FO';










