-- Tworzenie definicji funkcji avg_sales_window, która zwraca wartość liczbową, a przyjmuje wartości typu DATE w formacie RRRR-mm-dd.

sqlda=# CREATE FUNCTION avg_sales_window(from_date DATE, to_date DATE) RETURNS numeric AS $sales_avg$

-- Deklarowanie zwracanej zmiennej typu numeric i rozpoczynanie funkcji.

sqlda$# DECLARE sales_avg numeric;
sqlda$# BEGIN 

-- Zapisywanie w zwracanej zmiennej średniej wartości sprzedaży dla dat z podanego zakresu.

sqlda$# SELECT AVG(sales_amount) FROM sales INTO sales_avg WHERE sales_transaction_date > from_date AND sales_transaction_date < to_date;

-- Zwracanie zmiennej, kończenie funkcji i podawanie specyfikacji języka.

sqlda$# RETURN sales_avg;
sqlda$# END; $sales_avg$
sqlda-# LANGUAGE PLPGSQL;

-- Używanie funkcji do ustalenia średniej wartości sprzedaży z okresu od 2013-04-12 do 2014-04-12.

sqlda=# SELECT avg_sales_since('2013-04-12', '2014-04-12');
