-- Otwieranie PostgreSQL i nawiązywanie połączenia z bazą sqlda.

$ psql sqlda

-- Ustalanie listy klientów (z polami customer_id, first_name i last_name), do których wysłano e-mail. 
-- Należy uwzględnić informacje o temacie e-maila oraz o tym, czy odbiorca otworzył i kliknął wiadomość. 
-- Wynikowa tabela powinna obejmować kolumny customer_id, first_name, last_name, email_subject, opened i clicked.

sqlda=# SELECT customers.customer_id, customers.first_name, customers.last_name, emails.opened, emails.clicked FROM customers INNER JOIN emails ON customers.customer_id=emails.customer_id;

-- Zapisywanie wynikowych danych w nowej tabeli customer_emails.

sqlda=# SELECT customers.customer_id, customers.first_name, customers.last_name, emails.opened, emails.clicked INTO customer_emails FROM customers INNER JOIN emails ON customers.customer_id=emails.customer_id; 

-- Znajdowanie klientów, którzy otwarli lub kliknęli e-mail.

SELECT * FROM customer_emails WHERE clicked='t' and opened='t';

-- Znajdowanie klientów, w których mieście znajduje się salon. Klienci, w których miejscu 
-- zamieszkania nie ma salonu, powinni mieć pustą wartość w kolumnie city.

sqlda=# SELECT customers.customer_id, customers.first_name, customers.last_name, customers.city FROM customers LEFT JOIN dealerships on customers.city=dealerships.city;

-- Zapisywanie wyników w tabeli customer_dealers.

sqlda=# SELECT customers.customer_id, customers.first_name, customers.last_name, customers.city INTO customer_dealers FROM customers LEFT JOIN dealerships on customers.city=dealerships.city;

-- Wyświetlanie listy klientów, którzy nie mają salonu w swoim mieście (wskazówka — puste pole ma wartość NULL).

sqlda=# SELECT * from customer_dealers WHERE city is NULL;