-- Używanie poleceń EXPLAIN i ANALYZE do uzyskania planu wykonywania kwerendy, która wyszukuje wszystkie rekordy z adresem IP 18.131.58.65.

EXPLAIN ANALYZE SELECT * FROM customers WHERE ip_address = '18.131.58.65';

-- Tworzenie ogólnego indeksu dla kolumny ip_address.

CREATE INDEX ON customers(ip_address);

-- Ponowne wykonywanie kwerendy z kroku 1. w celu porównania czasu wykonania.

EXPLAIN ANALYZE SELECT * FROM customers WHERE ip_address = '18.131.58.65';

-- Tworzenie bardziej precyzyjnego indeksu dla kolumny ip_address z warunkiem, że adres IP musi być równy 18.131.58.65.

CREATE INDEX ix_ip_where ON customers(ip_address) WHERE ip_address = '18.131.58.65';

-- Ponowne wykonywanie kwerendy z kroku 1. w celu porównania czasu wykonania.

EXPLAIN ANALYZE SELECT * FROM customers WHERE ip_address = '18.131.58.65';.

-- Używanie poleceń EXPLAIN i ANALYZE do uzyskania planu wykonywania kwerendy, która wyszukuje wszystkie rekordy
-- z przyrostkiem 'Jr'.

EXPLAIN ANALYZE SELECT * FROM customers WHERE suffix = 'Jr';

-- Tworzenie ogólnego indeksu dla kolumny suffix.

CREATE INDEX ix_jr ON customers(suffix);

-- Ponowne wykonywanie kwerendy z kroku 6. w celu porównania czasu wykonania.

EXPLAIN ANALYZE SELECT * FROM customers WHERE suffix = 'Jr';




