-- Pobieranie liczby transakcji sprzedaży za pomocą funkcji COUNT.

SELECT COUNT(*)
FROM sales;

-- Określanie łącznej wartości transakcji sprzedaży w dolarach dla każdego stanu. Używana jest tu funkcja agregująca SUM.

SELECT c.state, SUM(sales_amount) as total_sales_amount
FROM sales s
INNER JOIN customers c ON c.customer_id=s.customer_id
GROUP BY 1
ORDER BY 1

-- Określanie pięciu pierwszych salonów z największą liczbą transakcji sprzedaży.
-- Używana jest do tego klauzula GROUP BY z klauzulą LIMIT równą 5.

SELECT s.dealership_id, COUNT(*)
FROM sales s
WHERE channel='dealership'
GROUP BY 1
ORDER BY 2 DESC
LIMIT 5

-- Obliczanie średniej wartość sprzedaży każdego produktu, każdego kanale i każdej kombinacji 
-- kanał-produkt na podstawie danych z tabeli sales.
-- Można do tego użyć klauzuli GROUPING SETS.

SELECT s.channel, s.product_id, AVG(sales_amount) as avg_sales_amount
FROM sales s
GROUP BY 
GROUPING SETS(
(s.channel), (s.product_id),
(s.channel, s.product_id)
)
ORDER BY 1, 2
