-- Nawiązywanie połączenia z bazą smalljoins.

$ psql smalljoins

-- Tworzenie nowej tabeli avg_qty_log zawierającej pola order_id typu integer i avg_qty typu numeric.

smalljoins=# CREATE TABLE avg_qty_log (order_id integer, avg_qty numeric);

-- Tworzenie funkcji avg_qty, która nie przyjmuje żadnych argumentów, a zwraca wyzwalacz. 
-- Ta funkcja ma obliczać średnią liczbę sztuk z wszystkich zamówień (order_info.qty) i wstawiać tę wartość
-- razem z najnowszym identyfikatorem order_id do tabeli avg_qty_log.

smalljoins=# CREATE FUNCTION avg_qty() RETURNS TRIGGER AS $_avg$
smalljoins$# DECLARE _avg numeric;
smalljoins$# BEGIN
smalljoins$# SELECT AVG(qty) INTO _avg FROM order_info;
smalljoins$# INSERT INTO avg_qty_log (order_id, avg_qty) VALUES (NEW.order_id, _avg);
smalljoins$# RETURN NEW;
smalljoins$# END; $_avg$
smalljoins-# LANGUAGE PLPGSQL; 

-- Tworzenie wyzwalacza avg_trigger, który wywołuje funkcję avg_qty PO wstawieniu każdego wiersza do tabeli order_info. 

smalljoins=# CREATE TRIGGER avg_trigger
smalljoins-# AFTER INSERT ON order_info
smalljoins-# FOR EACH ROW
smalljoins-# EXECUTE PROCEDURE avg_qty();

-- Wstawianie do tabeli order_info nowych wierszy z liczbą sztuk 6, 7 i 8.

smalljoins=# SELECT insert_order(3, 'GROG1', 6);
smalljoins=# SELECT insert_order(4, 'GROG1', 7);
smalljoins=# SELECT insert_order(1, 'GROG1', 8);

-- Przejrzyj rekordy z tabeli avg_qty_log. Czy średnia liczba sztuk po każdym zamówieniu rośnie?

smalljoins=# SELECT * FROM avg_qty_log;
