-- Używanie poleceń EXPLAIN i ANALYZE do ustalenia czasu i kosztu planowania oraz czasu i kosztu wykonania
-- kwerendy pobierającej wszystkie wiersze, w których temat e-maila to 'Shocking Holiday Savings On Electric Scooters'.

EXPLAIN ANALYZE SELECT * FROM emails where email_subject='Shocking Holiday Savings On Electric Scooters';

-- Używanie poleceń EXPLAIN i ANALYZE do ustalenia czasu i kosztu planowania oraz czasu i kosztu wykonania
-- kwerendy pobierającej wszystkie wiersze, w których temat e-maila to 'Black Friday. Green Cars'.

EXPLAIN ANALYZE SELECT * FROM emails where email_subject='Black Friday. Green Cars.';

-- Tworzenie indeksu z haszowaniem dla kolumny email_subject.

CREATE INDEX ix_email_subject ON emails USING HASH(email_subject);

-- Powtórzenie kroku 1. z rozwiązania i porównanie danych wyjściowych.

EXPLAIN ANALYZE SELECT * FROM emails where email_subject='Shocking Holiday Savings On Electric Scooters';

-- Powtórzenie kroku 2. z rozwiązania i porównanie danych wyjściowych.

EXPLAIN ANALYZE SELECT * FROM emails where email_subject='Black Friday. Green Cars.';

-- Tworzenie indeksu z haszowaniem dla kolumny customer_id.

CREATE INDEX ix_customer_id ON emails USING HASH(customer_id);

-- Używanie poleceń EXPLAIN i ANALYZE do oszacowania czasu pobierania wszystkich wierszy, w których 
-- kolumna customer_id ma wartość większą niż 100.

EXPLAIN ANALYZE SELECT * FROM emails WHERE customer_id > 100;

