
-- 
SELECT DISTINCT(City) FROM Person.Address

-- 
SET SHOWPLAN_XML ON
GO
SELECT DISTINCT(City) FROM Person.Address
GO
SET SHOWPLAN_XML OFF

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE OrderQty = 1

-- 
SET SHOWPLAN_TEXT ON
GO
SELECT DISTINCT(City) FROM Person.Address
GO
SET SHOWPLAN_TEXT OFF
GO

-- 
SET SHOWPLAN_ALL ON
GO
SELECT DISTINCT(City) FROM Person.Address
GO
SET SHOWPLAN_ALL OFF
GO

-- 
SET STATISTICS PROFILE ON
GO
SELECT * FROM Sales.SalesOrderDetail
WHERE OrderQty * UnitPrice > 25000
GO
SET STATISTICS PROFILE OFF
GO

-- 
SELECT * FROM Sales.SalesOrderHeader
WHERE SalesOrderID = 43666

-- 
SELECT * FROM Sales.SalesOrderHeader
WHERE SalesOrderID = 43666
OPTION (QUERYTRACEON 8757)

-- 
SELECT pm.ProductModelID, pm.Name, Description, pl.CultureID,
cl.Name AS Language
FROM Production.ProductModel AS pm
	JOIN Production.ProductModelProductDescriptionCulture AS pl
		ON pm.ProductModelID = pl.ProductModelID
	JOIN Production.Culture AS cl
		ON cl.CultureID = pl.CultureID
	JOIN Production.ProductDescription AS pd
		ON pd.ProductDescriptionID = pl.ProductDescriptionID
ORDER BY pm.ProductModelID

-- 
SELECT * FROM Sales.SalesOrderHeader
WHERE SalesOrderID = 43666
OPTION (MAXDOP 1)

-- 
SELECT CustomerID, ('AW' + dbo.ufnLeadingZeros(CustomerID))
	AS GenerateAccountNumber
FROM Sales.Customer
ORDER BY CustomerID

-- 
SELECT * FROM Sales.SalesOrderHeader
WHERE SalesOrderID = 43666
OPTION (MAXDOP 8)

-- 
SELECT DISTINCT(CustomerID)
FROM Sales.SalesOrderHeader

-- 
DROP STATISTICS HumanResources.Employee._WA_Sys_0000000C_49C3F6B7

-- 
ALTER DATABASE AdventureWorks2012 SET AUTO_CREATE_STATISTICS OFF

-- 
SELECT * FROM HumanResources.Employee
WHERE VacationHours = 48

-- 
ALTER DATABASE AdventureWorks2012 SET AUTO_CREATE_STATISTICS ON

-- 
SELECT * FROM Sales.SalesOrderHeader soh, Sales.SalesOrderDetail sod
WHERE soh.SalesOrderID = sod.SalesOrderID

-- 
SELECT * FROM Sales.SalesOrderHeader soh JOIN Sales.SalesOrderDetail sod
-- ON soh.SalesOrderID = sod.SalesOrderID

-- 
DECLARE @code nvarchar(15)
SET @code = '95555Vi4081'
SELECT * FROM Sales.SalesOrderHeader
WHERE CreditCardApprovalCode = @code

-- 
SELECT * FROM Sales.SalesOrderDetail
ORDER BY UnitPrice

-- 
CREATE INDEX IX_Color ON Production.Product(Name, ProductNumber)
WHERE Color = 'White'

-- 
DECLARE @color nvarchar(15)
SET @color = 'White'
SELECT Name, ProductNumber FROM Production.Product
WHERE Color = @color

-- 
SELECT Name, ProductNumber FROM Production.Product
WHERE Color = 'White'

-- 
DROP INDEX Production.Product.IX_Color

-- 
SELECT * FROM sys.dm_exec_requests
CROSS APPLY
sys.dm_exec_query_plan(plan_handle)

-- 
SELECT * FROM sys.dm_exec_query_stats
CROSS APPLY
sys.dm_exec_query_plan(plan_handle)

-- 
SELECT TOP 10 total_worker_time/execution_count AS avg_cpu_time,
plan_handle, query_plan
FROM sys.dm_exec_query_stats
CROSS APPLY sys.dm_exec_query_plan(plan_handle)
ORDER BY avg_cpu_time DESC

-- 
/****************************************************/
/* Created by: SQL Server 2014 Profiler */
/* Date: 12/18/2013 08:37:22 AM */
/****************************************************/
-- Create a Queue
declare @rc int
declare @TraceID int
declare @maxfilesize bigint
set @maxfilesize = 5
-- Please replace the text InsertFileNameHere, with an appropriate
-- filename prefixed by a path, e.g., c:\MyFolder\MyTrace. The .trc extension
-- will be appended to the filename automatically. If you are writing from
-- remote server to local drive, please use UNC path and make sure server has
-- write access to your network share
exec @rc = sp_trace_create @TraceID output, 0, N'InsertFileNameHere', @maxfilesize,
NULL
if (@rc != 0) goto error
-- Client side File and Table cannot be scripted
-- Set the events
declare @on bit
set @on = 1
exec sp_trace_setevent @TraceID, 10, 1, @on
exec sp_trace_setevent @TraceID, 10, 9, @on
exec sp_trace_setevent @TraceID, 10, 2, @on
exec sp_trace_setevent @TraceID, 10, 66, @on
exec sp_trace_setevent @TraceID, 10, 10, @on
exec sp_trace_setevent @TraceID, 10, 3, @on
exec sp_trace_setevent @TraceID, 10, 4, @on
exec sp_trace_setevent @TraceID, 10, 6, @on
exec sp_trace_setevent @TraceID, 10, 7, @on
exec sp_trace_setevent @TraceID, 10, 8, @on
exec sp_trace_setevent @TraceID, 10, 11, @on
exec sp_trace_setevent @TraceID, 10, 12, @on
exec sp_trace_setevent @TraceID, 10, 13, @on

-- 
CREATE EVENT SESSION [test] ON SERVER
ADD EVENT sqlserver.query_post_execution_showplan(
	ACTION(sqlserver.plan_handle)
	WHERE ([sqlserver].[database_name]=N'AdventureWorks2012'))
ADD TARGET package0.ring_buffer
WITH (STARTUP_STATE=OFF)
GO

-- 
ALTER EVENT SESSION [test]
ON SERVER
STATE=START

-- 
SELECT
	event_data.value('(event/@name)[1]', 'varchar(50)') AS event_name,
	event_data.value('(event/action[@name="plan_handle"]/value)[1]',
		'varchar(max)') as plan_handle,
	event_data.query('event/data[@name="showplan_xml"]/value/*') as showplan_xml,
	event_data.value('(event/action[@name="sql_text"]/value)[1]',
		'varchar(max)') AS sql_text
FROM( SELECT evnt.query('.') AS event_data
FROM
( SELECT CAST(target_data AS xml) AS target_data
FROM sys.dm_xe_sessions AS s
JOIN sys.dm_xe_session_targets AS t
ON s.address = t.event_session_address
WHERE s.name = 'test'
AND t.target_name = 'ring_buffer'
) AS data
CROSS APPLY target_data.nodes('RingBufferTarget/event') AS xevent(evnt)
) AS xevent(event_data)

-- 
ALTER EVENT SESSION [test]
ON SERVER
STATE=STOP
GO
DROP EVENT SESSION [test] ON SERVER

-- 
SET STATISTICS TIME ON

-- 
SELECT DISTINCT(CustomerID)
FROM Sales.SalesOrderHeader

-- 
SET STATISTICS TIME OFF

-- 
SET STATISTICS IO ON

-- 
DBCC DROPCLEANBUFFERS

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE ProductID = 870

-- 
SELECT * FROM Sales.SalesOrderHeader
WHERE SalesOrderID = 51119

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE SalesOrderID = 51119

-- 
SELECT * FROM Sales.SalesOrderHeader
WHERE SalesOrderID IN (51119, 43664, 63371, 75119)

