-- 
ALTER DATABASE AdventureWorks2012
SET COMPATIBILITY_LEVEL = 120

-- 
SELECT * FROM sys.stats
WHERE object_id = OBJECT_ID('Sales.SalesOrderDetail')

-- 
DBCC SHOW_STATISTICS ('Sales.SalesOrderDetail', UnitPrice)

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE UnitPrice = 35

-- 
DBCC SHOW_STATISTICS ('Sales.SalesOrderDetail', IX_SalesOrderDetail_ProductID)

-- 
SELECT ProductID FROM Sales.SalesOrderDetail
GROUP BY ProductID

-- 
DECLARE @ProductID int
SET @ProductID = 921
SELECT ProductID FROM Sales.SalesOrderDetail
WHERE ProductID = @ProductID

-- 
DECLARE @pid int = 897
SELECT * FROM Sales.SalesOrderDetail
WHERE ProductID < @pid

-- 
DBCC SHOW_STATISTICS ('Sales.SalesOrderDetail', IX_SalesOrderDetail_ProductID)

-- 
SELECT ProductID, COUNT(*) AS Total
FROM Sales.SalesOrderDetail
WHERE ProductID BETWEEN 827 AND 831
GROUP BY ProductID

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE ProductID = 831

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE ProductID < 714

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 110

-- 
SELECT * FROM Person.Address WHERE City = 'Burbank'

-- 
SELECT * FROM Person.Address WHERE PostalCode = '91502'

-- 
SELECT * FROM Person.Address
WHERE City = 'Burbank' AND PostalCode = '91502'

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 120
GO
SELECT * FROM Person.Address WHERE City = 'Burbank' AND PostalCode = '91502'

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 110
GO
SELECT * FROM Person.Address WHERE City = 'Burbank' OR PostalCode = '91502'

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 120
GO
SELECT * FROM Person.Address WHERE City = 'Burbank' OR PostalCode = '91502'

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 120
GO
SELECT * FROM Person.Address WHERE City = 'Burbank' AND PostalCode = '91502'
OPTION (QUERYTRACEON 9481)

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 110
GO
SELECT * FROM Person.Address
WHERE City = 'Burbank' AND PostalCode = '91502'
OPTION (QUERYTRACEON 4137)

-- 
SET STATISTICS PROFILE ON
GO
SELECT * FROM Sales.SalesOrderDetail
WHERE OrderQty * UnitPrice > 10000
GO
SET STATISTICS PROFILE OFF
GO

-- 
CREATE PARTITION FUNCTION TransactionRangePF1 (datetime)
AS RANGE RIGHT FOR VALUES
(
'20071001', '20071101', '20071201', '20080101',
'20080201', '20080301', '20080401', '20080501',
'20080601', '20080701', '20080801'
)
GO
CREATE PARTITION SCHEME TransactionsPS1 AS PARTITION TransactionRangePF1 TO
(
[PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY],
[PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY],
[PRIMARY], [PRIMARY], [PRIMARY]
)
GO
CREATE TABLE dbo.TransactionHistory
(
TransactionID int NOT NULL,
ProductID int NOT NULL,
ReferenceOrderID int NOT NULL,
ReferenceOrderLineID int NOT NULL DEFAULT (0),
TransactionDate datetime NOT NULL DEFAULT (GETDATE()),
TransactionType nchar(1) NOT NULL,
Quantity int NOT NULL,
ActualCost money NOT NULL,
ModifiedDate datetime NOT NULL DEFAULT (GETDATE()),
CONSTRAINT CK_TransactionType
CHECK (UPPER(TransactionType) IN (N'W', N'S', N'P'))
)
ON TransactionsPS1 (TransactionDate)
GO

-- 
INSERT INTO dbo.TransactionHistory
SELECT * FROM Production.TransactionHistory
WHERE TransactionDate < '2008-08-01'

-- 
SELECT * FROM sys.partitions
WHERE object_id = OBJECT_ID('dbo.TransactionHistory')

-- 
CREATE STATISTICS incrstats ON dbo.TransactionHistory(TransactionDate)
WITH FULLSCAN, INCREMENTAL = ON

-- 
DBCC SHOW_STATISTICS('dbo.TransactionHistory', incrstats)

-- 
INSERT INTO dbo.TransactionHistory
SELECT * FROM Production.TransactionHistory
WHERE TransactionDate >= '2008-08-01'

-- 
UPDATE STATISTICS dbo.TransactionHistory(incrstats)
WITH RESAMPLE ON PARTITIONS(12)

-- 
UPDATE STATISTICS dbo.TransactionHistory(incrstats)
WITH FULLSCAN, INCREMENTAL = OFF

-- 
DROP TABLE dbo.TransactionHistory
DROP PARTITION SCHEME TransactionsPS1
DROP PARTITION FUNCTION TransactionRangePF1

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE OrderQty * UnitPrice > 10000

-- 
ALTER TABLE Sales.SalesOrderDetail
ADD cc AS OrderQty * UnitPrice

-- 
SELECT * FROM sys.stats
WHERE object_id = OBJECT_ID('Sales.SalesOrderDetail')

-- 
DBCC SHOW_STATISTICS ('Sales.SalesOrderDetail', _WA_Sys_0000000E_44CA3770)

-- 
DBCC SHOW_STATISTICS ('Sales.SalesOrderDetail', cc)

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE UnitPrice * OrderQty > 10000

-- 
ALTER TABLE Sales.SalesOrderDetail
DROP COLUMN cc

-- 
SELECT * FROM Person.Address
WHERE City = 'Los Angeles'

-- 
SELECT * FROM Person.Address
WHERE StateProvinceID = 9

-- 
SELECT * FROM Person.Address
WHERE City = 'Los Angeles' AND StateProvinceID = 9

-- 
CREATE STATISTICS california
ON Person.Address(City)
WHERE StateProvinceID = 9

-- 
DBCC FREEPROCCACHE
GO
SELECT * FROM Person.Address
WHERE City = 'Los Angeles' AND StateProvinceID = 9

-- 
DBCC SHOW_STATISTICS('Person.Address', california)

-- 
DROP STATISTICS Person.Address.california

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 110
GO
CREATE TABLE dbo.SalesOrderHeader (
SalesOrderID int NOT NULL,
RevisionNumber tinyint NOT NULL,
OrderDate datetime NOT NULL,
DueDate datetime NOT NULL,
ShipDate datetime NULL,
Status tinyint NOT NULL,
OnlineOrderFlag dbo.Flag NOT NULL,
SalesOrderNumber nvarchar(25) NOT NULL,
PurchaseOrderNumber dbo.OrderNumber NULL,
AccountNumber dbo.AccountNumber NULL,
CustomerID int NOT NULL,
SalesPersonID int NULL,
TerritoryID int NULL,
BillToAddressID int NOT NULL,
ShipToAddressID int NOT NULL,
ShipMethodID int NOT NULL,
CreditCardID int NULL,
CreditCardApprovalCode varchar(15) NULL,
CurrencyRateID int NULL,
SubTotal money NOT NULL,
TaxAmt money NOT NULL,
Freight money NOT NULL,
TotalDue money NOT NULL,
Comment nvarchar(128) NULL,
rowguid uniqueidentifier NOT NULL,
ModifiedDate datetime NOT NULL
)

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate < '2008-07-20 00:00:00.000'
CREATE INDEX IX_OrderDate ON SalesOrderHeader(OrderDate)

-- 
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-19 00:00:00.000'

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate = '2008-07-20 00:00:00.000'

-- 
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-20 00:00:00.000'

-- 
DBCC TRACEON (2388)
DBCC TRACEON (2389)

-- 
DBCC SHOW_STATISTICS ('dbo.SalesOrderHeader', 'IX_OrderDate')

-- 
UPDATE STATISTICS dbo.SalesOrderHeader WITH FULLSCAN

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate = '2008-07-21 00:00:00.000'

-- 
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-21 00:00:00.000'

-- 
UPDATE STATISTICS dbo.SalesOrderHeader WITH FULLSCAN

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate = '2008-07-22 00:00:00.000'

-- 
UPDATE STATISTICS dbo.SalesOrderHeader WITH FULLSCAN

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate = '2008-07-23 00:00:00.000'

-- 
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-23 00:00:00.000'

-- 
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-24 00:00:00.000'

-- 
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-23 00:00:00.000'
OPTION (QUERYTRACEON 2389, QUERYTRACEON 2390)

-- 
DROP TABLE dbo.SalesOrderHeader

-- 
DBCC TRACEOFF (2388)
DBCC TRACEOFF (2389)

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate < '2008-07-20 00:00:00.000'
CREATE INDEX IX_OrderDate ON SalesOrderHeader(OrderDate)

-- 
INSERT INTO dbo.SalesOrderHeader SELECT * FROM Sales.SalesOrderHeader
WHERE OrderDate = '2008-07-20 00:00:00.000'

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 110
GO
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-20 00:00:00.000'

-- 
ALTER DATABASE AdventureWorks2012 SET COMPATIBILITY_LEVEL = 120
GO
SELECT * FROM dbo.SalesOrderHeader WHERE OrderDate = '2008-07-20 00:00:00.000'

-- 
SELECT * INTO dbo.Address
FROM Person.Address

-- 
SELECT * FROM sys.dm_db_partition_stats
WHERE object_id = OBJECT_ID('dbo.Address')

-- 
SELECT * FROM dbo.Address
WHERE City = 'London'

-- 
UPDATE STATISTICS dbo.Address WITH ROWCOUNT = 1000000, PAGECOUNT = 100000

-- 
DBCC FREEPROCCACHE
GO
SELECT * FROM dbo.Address WHERE City = 'London'

-- 
DBCC UPDATEUSAGE(AdventureWorks2012, 'dbo.Address') WITH COUNT_ROWS

-- 
DROP TABLE dbo.Address

-- 
SELECT l.SalesOrderID, l.CustomerID
FROM AdventureWorks2012.Sales.SalesOrderHeader l
JOIN [remote].AdventureWorks2012.Sales.SalesOrderHeader r
ON l.SalesOrderID = r.SalesOrderID
WHERE r.CustomerID = 11000

-- 
DBCC TRACEON (9485)

-- 
SELECT * INTO dbo.SalesOrderDetail FROM Sales.SalesOrderDetail

-- 
SELECT name, auto_created, STATS_DATE(object_id, stats_id) AS update_date
FROM sys.stats
WHERE object_id = OBJECT_ID('dbo.SalesOrderDetail')

-- 
SELECT * FROM dbo.SalesOrderDetail
WHERE SalesOrderID = 43670 AND OrderQty = 1

-- 
CREATE INDEX IX_ProductID ON dbo.SalesOrderDetail(ProductID)

-- 
UPDATE STATISTICS dbo.SalesOrderDetail WITH FULLSCAN, COLUMNS

-- 
UPDATE STATISTICS dbo.SalesOrderDetail WITH FULLSCAN, INDEX

-- 
UPDATE STATISTICS dbo.SalesOrderDetail WITH FULLSCAN
UPDATE STATISTICS dbo.SalesOrderDetail WITH FULLSCAN, ALL

-- 
ALTER INDEX ix_ProductID ON dbo.SalesOrderDetail REBUILD

-- 
ALTER INDEX ix_ProductID on dbo.SalesOrderDetail REORGANIZE

-- 
DROP TABLE dbo.SalesOrderDetail

-- 
SELECT * FROM Sales.SalesOrderDetail
WHERE LineTotal = 35

-- 
SELECT in_row_data_page_count, row_count
FROM sys.dm_db_partition_stats
WHERE object_id = OBJECT_ID('Sales.SalesOrderDetail')
AND index_id = 1

