<%@ taglib prefix="s" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>

<div>        
  <sec:authorize access="!isAuthenticated()">
			
		<div class="msg">
		  <h3>Zaloguj si!</h3>
		</div>
   
		<form class="signin" action="<s:url value="/static/j_spring_security_check"/>" method="post">
		  <fieldset>
		    <div>
		      <label for="j_username">Nazwa uytkownika lub e-mail</label>
		      <input id="email" type="text" name="j_username"/>
		    </div>
		    <div>
		      <label for="j_password">Haso</label>
		      <input id="pass" type="password" name="j_password"/>
		    </div>
		    <input id="remember_me" type="checkbox" value="1" 
		           name="_spring_security_remember_me"/>
		    <label for="remember_me">Pamitaj mnie</label>
		    <small>
		      <a href="/account/resend_password">Zapomniae?</a>
		    </small>
		    <input id="submit" type="submit" value="Sign In!" 
		           name="commit"/>
		  </fieldset>
		</form>
		<div class="notify">
		  Chcesz zaoy konto?   
		  <br/>
		  <a class="join" href="<s:url value="/spitters?new"/>">Zarejestruj si za darmo!</a>
		  <br/>
		  To szybkie i atwe!
		</div>
	</sec:authorize>
	
  <sec:authorize access="isAuthenticated()">
    <s:url value="/resources/images" var="images_url" />
	  <img src="${images_url}/spitter_me.jpg" align="middle"/>
	  <span><sec:authentication 
	        property="principal.username" /></span>
	  <br/>
    <s:url value="/static/j_spring_security_logout" 
                var="logout_url" /> 
	  <a href="${logout_url}">Logout</a>
	  <sec:authorize url="/admin">
      <s:url value="/admin" var="admin_url" />
	    <br/><a href="${admin_url}">Admin</a>
	  </sec:authorize>
	</sec:authorize>
</div>