package tacos;

import java.util.Arrays;

import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;

import tacos.Ingredient.Type;
import tacos.data.IngredientRepository;
import tacos.data.PaymentMethodRepository;
import tacos.data.TacoRepository;
import tacos.data.UserRepository;

@Profile("!prod")
@Configuration
public class DevelopmentConfig {

  @Bean
  public CommandLineRunner dataLoader(IngredientRepository repo,
        UserRepository userRepo, PasswordEncoder encoder, TacoRepository tacoRepo,
        PaymentMethodRepository paymentMethodRepo) { // Repozytorium użytkownika do przetestowania wraz z profilem użytkownika wbudowanego
    return new CommandLineRunner() {
      @Override
      public void run(String... args) throws Exception {
        IngredientUDT flourTortilla = saveAnIngredient("FLTO", "pszenna", Type.WRAP);
        IngredientUDT cornTortilla = saveAnIngredient("COTO", "kukurydziana", Type.WRAP);
        IngredientUDT groundBeef = saveAnIngredient("GRBF", "mielona wołowina", Type.PROTEIN);
        IngredientUDT carnitas = saveAnIngredient("CARN", "kawałki mięsa", Type.PROTEIN);
        IngredientUDT tomatoes = saveAnIngredient("TMTO", "pomidory pokrojone w kostkę", Type.VEGGIES);
        IngredientUDT lettuce = saveAnIngredient("LETC", "sałata", Type.VEGGIES);
        IngredientUDT cheddar = saveAnIngredient("CHED", "cheddar", Type.CHEESE);
        IngredientUDT jack = saveAnIngredient("JACK", "Monterrey Jack", Type.CHEESE);
        IngredientUDT salsa = saveAnIngredient("SLSA", "pikantny sos pomidorowy", Type.SAUCE);
        IngredientUDT sourCream = saveAnIngredient("SRCR", "śmietana", Type.SAUCE);
        
//        UserUDT u = new UserUDT(username, fullname, phoneNumber)
        
        userRepo.save(new User("habuma", encoder.encode("password"), 
              "Jan Kowalski", "ul. Dobra 123", "Gliwice", "TX", 
              "76227", "123-123-1234", "craig@habuma.com"))
          .map(user -> new UserUDT(user.getUsername(), user.getFullname(), user.getPhoneNumber()))
          .subscribe(user -> {
              paymentMethodRepo.save(new PaymentMethod(user, "4111111111111111", "321", "10/25")).subscribe();
          });        
        
        Taco taco1 = new Taco();
        taco1.setName("Carnivore");
        taco1.setIngredients(Arrays.asList(flourTortilla, groundBeef, carnitas, sourCream, salsa, cheddar));
        tacoRepo.save(taco1).subscribe();

        Taco taco2 = new Taco();
        taco2.setName("Bovine Bounty");
        taco2.setIngredients(Arrays.asList(cornTortilla, groundBeef, cheddar, jack, sourCream));
        tacoRepo.save(taco2).subscribe();

        Taco taco3 = new Taco();
        taco3.setName("Veg-Out");
        taco3.setIngredients(Arrays.asList(flourTortilla, cornTortilla, tomatoes, lettuce, salsa));
        tacoRepo.save(taco3).subscribe();

      }

      private IngredientUDT saveAnIngredient(String id, String name, Type type) {
        Ingredient ingredient = new Ingredient(id, name, type);
        repo.save(ingredient).subscribe();
        return new IngredientUDT(name, type);
      }
    };
  }
  
}
