package tacos;

import static org.hamcrest.Matchers.containsString;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;

import tacos.data.IngredientRepository;
import tacos.data.OrderRepository;
import tacos.data.TacoRepository;
import tacos.data.UserRepository;

@RunWith(SpringRunner.class)
@WebMvcTest(secure=false)
public class HomeControllerTest {

  @Autowired
  private MockMvc mockMvc;
  
  // Uwaga: Większość tych imitacji ma pomóc w uniknięciu problemów związanych z łączeniem komponentów.
  //        Tak naprawdę nie są one używane podczas testowania strony główej, więc sposób ich zachowania
  //        nie ma znaczenia. Muszą istnieć, aby zapewnić automatyczne łączenie komponentów.

  @MockBean
  private IngredientRepository ingredientRepository;

  @MockBean
  private TacoRepository designRepository;

  @MockBean
  private OrderRepository orderRepository;

  @MockBean
  private UserRepository userRepository;
  
  @MockBean
  private PasswordEncoder passwordEncoder;

  @Test
  public void testHomePage() throws Exception {
    mockMvc.perform(get("/abc"))
      .andExpect(status().isOk())
      .andExpect(view().name("home"))
      .andExpect(content().string(
          containsString("Witaj w...")));  
  }

}
