package tacos.ingredients;
import java.util.Calendar;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

//@Component
public class WackoHealthIndicator 
       implements HealthIndicator {

  @Override
  public Health health() {
    int hour = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
    if (hour > 12) {
      return Health
          .outOfService()
          .withDetail("reason",
              "Jestem niedostępny po obiedzie")
       .withDetail("hour", hour)
       .build();
    }
    
    if (Math.random() < 0.1) {
      return Health
          .down()
          .withDetail("reason", "Jestem niedostępny przez 10% czasu")
          .build();
    }
    
    return Health
        .up()
        .withDetail("reason", "Wszystko w porządku!")
        .build();
  }
}
